<?php
// Hata raporlamayı etkinleştir
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'config.php';
require_once 'BotAPI.php';

$baslik = "Webhook Kurulumu";
$mesaj = "";
$webhook_url = "";
$token = BOT_TOKEN;

// Webhook URL'sini otomatik tespit et
if (isset($_SERVER['HTTP_HOST']) && isset($_SERVER['PHP_SELF'])) {
    $webhook_url = "https://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/index.php";
    $webhook_url = str_replace("\\", "/", $webhook_url);
}

// Webhook silme işlemi
if (isset($_POST['sil'])) {
    $token = $_POST['token'] ?? BOT_TOKEN;
    $bot = new BotAPI($token);
    
    // Webhook'u sil
    $sonuc = $bot->request('deleteWebhook', []);
    
    if (isset($sonuc['ok']) && $sonuc['ok']) {
        $mesaj = '<div class="alert alert-success">Webhook başarıyla silindi! Bot artık webhook kullanmıyor.</div>';
    } else {
        $mesaj = '<div class="alert alert-danger">Webhook silinirken hata oluştu: ' . (isset($sonuc['description']) ? $sonuc['description'] : 'Bilinmeyen hata') . '</div>';
    }
}

// Webhook kurma işlemi
if (isset($_POST['kur'])) {
    $token = $_POST['token'] ?? BOT_TOKEN;
    $webhook_url = $_POST['webhook_url'] ?? $webhook_url;
    
    $bot = new BotAPI($token);
    
    // Webhook'u kur
    $sonuc = $bot->request('setWebhook', [
        'url' => $webhook_url,
        'max_connections' => 40,
        'drop_pending_updates' => true
    ]);
    
    if (isset($sonuc['ok']) && $sonuc['ok']) {
        $mesaj = '<div class="alert alert-success">Webhook başarıyla kuruldu! Bot artık mesajları alacak.</div>';
        
        // Token ve webhook URL'sini veritabanına kaydet
        $vt->query("UPDATE ayarlar SET deger = '" . $vt->real_escape_string($token) . "' WHERE anahtar = 'BOT_TOKEN'");
        $vt->query("UPDATE ayarlar SET deger = '" . $vt->real_escape_string($webhook_url) . "' WHERE anahtar = 'WEBHOOK_URL'");
    } else {
        $mesaj = '<div class="alert alert-danger">Webhook kurulurken hata oluştu: ' . (isset($sonuc['description']) ? $sonuc['description'] : 'Bilinmeyen hata') . '</div>';
    }
}

// Webhook durumunu kontrol et
if (isset($_POST['kontrol']) || empty($mesaj)) {
    $token = $_POST['token'] ?? BOT_TOKEN;
    $bot = new BotAPI($token);
    
    $sonuc = $bot->request('getWebhookInfo', []);
    
    if (isset($sonuc['ok']) && $sonuc['ok']) {
        $webhook_info = $sonuc['result'];
        $mesaj = '<div class="alert alert-info">
            <strong>Webhook Durumu:</strong><br>
            URL: ' . (isset($webhook_info['url']) ? htmlspecialchars($webhook_info['url']) : 'Yok') . '<br>
            Bekleyen Güncelleme: ' . (isset($webhook_info['pending_update_count']) ? $webhook_info['pending_update_count'] : '0') . '<br>
            Son Hata: ' . (isset($webhook_info['last_error_message']) ? htmlspecialchars($webhook_info['last_error_message']) : 'Yok') . '<br>
            Son Hata Zamanı: ' . (isset($webhook_info['last_error_date']) ? date('Y-m-d H:i:s', $webhook_info['last_error_date']) : 'Yok') . '
        </div>';
    } else {
        $mesaj = '<div class="alert alert-danger">Webhook bilgisi alınırken hata oluştu: ' . (isset($sonuc['description']) ? $sonuc['description'] : 'Bilinmeyen hata') . '</div>';
    }
}

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $baslik; ?></title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0"><?php echo $baslik; ?></h4>
                    </div>
                    <div class="card-body">
                        <?php echo $mesaj; ?>
                        
                        <div class="alert alert-warning">
                            <strong>Bilgi:</strong> Webhook kurulumu için SSL sertifikalı bir sunucu gereklidir. Webhook URL'si https:// ile başlamalıdır.
                        </div>
                        
                        <ul class="nav nav-tabs mb-3" id="myTab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="kur-tab" data-toggle="tab" href="#kur" role="tab">Webhook Kur</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="sil-tab" data-toggle="tab" href="#sil" role="tab">Webhook Sil</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="kontrol-tab" data-toggle="tab" href="#kontrol" role="tab">Webhook Kontrol</a>
                            </li>
                        </ul>
                        
                        <div class="tab-content" id="myTabContent">
                            <!-- Webhook Kurma Formu -->
                            <div class="tab-pane fade show active" id="kur" role="tabpanel">
                                <form method="post" action="">
                                    <div class="form-group">
                                        <label for="token">Bot Token:</label>
                                        <input type="text" class="form-control" id="token" name="token" value="<?php echo htmlspecialchars($token); ?>" required>
                                        <small class="form-text text-muted">BotFather'dan aldığınız bot token'ı.</small>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="webhook_url">Webhook URL:</label>
                                        <input type="text" class="form-control" id="webhook_url" name="webhook_url" value="<?php echo htmlspecialchars($webhook_url); ?>" required>
                                        <small class="form-text text-muted">Bot'un mesajları alacağı URL. Otomatik tespit edildi, değiştirmeniz gerekmez.</small>
                                    </div>
                                    
                                    <button type="submit" name="kur" class="btn btn-success">Webhook Kur</button>
                                </form>
                            </div>
                            
                            <!-- Webhook Silme Formu -->
                            <div class="tab-pane fade" id="sil" role="tabpanel">
                                <form method="post" action="">
                                    <div class="form-group">
                                        <label for="token_sil">Bot Token:</label>
                                        <input type="text" class="form-control" id="token_sil" name="token" value="<?php echo htmlspecialchars($token); ?>" required>
                                    </div>
                                    
                                    <div class="alert alert-danger">
                                        <strong>Uyarı:</strong> Webhook'u sildiğinizde bot mesajları almayı durdurur. Sadece sorun yaşadığınızda veya yeniden kurmak istediğinizde silin.
                                    </div>
                                    
                                    <button type="submit" name="sil" class="btn btn-danger" onclick="return confirm('Webhook\'u silmek istediğinizden emin misiniz?');">Webhook Sil</button>
                                </form>
                            </div>
                            
                            <!-- Webhook Kontrol Formu -->
                            <div class="tab-pane fade" id="kontrol" role="tabpanel">
                                <form method="post" action="">
                                    <div class="form-group">
                                        <label for="token_kontrol">Bot Token:</label>
                                        <input type="text" class="form-control" id="token_kontrol" name="token" value="<?php echo htmlspecialchars($token); ?>" required>
                                    </div>
                                    
                                    <button type="submit" name="kontrol" class="btn btn-info">Webhook Durumunu Kontrol Et</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
