<?php
/**
 * Betplay Telegram Davet Turnuvası Bot
 * Polling mekanizması (yerel geliştirme için)
 */
require_once 'config.php';
require_once 'BotAPI.php';
require_once 'fonksiyonlar.php';
require_once 'fonksiyonlar2.php';

// Bot'u başlat
$bot = new BotAPI(BOT_TOKEN);

// Son güncelleme ID'sini saklamak için
$last_update_id = 0;

echo "Bot polling başlatıldı. Çıkmak için Ctrl+C tuşlarına basın...\n";

// Sonsuz döngü ile güncellemeleri kontrol et
while (true) {
    // Telegram'dan güncellemeleri al
    $updates = $bot->guncellemeleriAl($last_update_id + 1);
    
    if (!empty($updates['result'])) {
        foreach ($updates['result'] as $update) {
            // Son güncelleme ID'sini güncelle
            $last_update_id = $update['update_id'];
            
            // Güncellemeyi işle
            if (isset($update['message'])) {
                mesajIsleme($bot, $update['message']);
                echo "Mesaj işlendi: " . ($update['message']['text'] ?? 'Metin yok') . "\n";
            } elseif (isset($update['callback_query'])) {
                callbackIsleme($bot, $update['callback_query']);
                echo "Callback sorgusu işlendi: " . $update['callback_query']['data'] . "\n";
            } elseif (isset($update['chat_join_request'])) {
                katilmaIstegiIsleme($bot, $update['chat_join_request']);
                echo "Katılma isteği işlendi\n";
            } elseif (isset($update['chat_member'])) {
                sohbetUyesiGuncellemeIsleme($bot, $update['chat_member']);
                echo "Sohbet üyesi güncellemesi işlendi\n";
            }
        }
    }
    
    // 1 saniye bekle
    sleep(1);
}
?>
