<?php
/**
 * Kullanıcının davet linkini gönder
 * 
 * @param BotAPI $bot Bot API nesnesi
 * @param int $chat_id Sohbet ID
 * @param int $telegram_id Telegram ID
 */
function davetLinkiGonder($bot, $chat_id, $telegram_id) {
    global $vt;
    
    // Etkinlik aktif mi kontrol et
    if (!etkinlikAktifMi()) {
        $bot->mesajGonder($chat_id, "⚠️ *Şu anda aktif bir etkinlik bulunmuyor.*\n\nEtkinliğe başladığında bildirim alacaksınız.", 'markdown');
        return false;
    }
    
    // Kanal kontrolü yap
    if (!kanallariTakipEdiyor($bot, $telegram_id)) {
        kanalTakipIste($bot, $chat_id);
        return false;
    }
    
    // Telefon kontrolü yap
    if (!telefonuVar($vt, $telegram_id)) {
        telefonIsteFonk($bot, $chat_id);
        return false;
    }
    
    // Kullanıcının davet linkini al
    $stmt = $vt->prepare("SELECT davet_linki, davet_kodu FROM kullanicilar WHERE telegram_id = ?");
    $stmt->bind_param("i", $telegram_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    
    if ($row) {
        // Davet sayısını al
        $stmt = $vt->prepare("
            SELECT COUNT(*) as davet_sayisi 
            FROM davetler d 
            JOIN kullanicilar k ON d.davet_eden_id = k.id 
            WHERE k.telegram_id = ? AND d.aktif = TRUE
        ");
        $stmt->bind_param("i", $telegram_id);
        $stmt->execute();
        $davet_result = $stmt->get_result();
        $davet_row = $davet_result->fetch_assoc();
        $davet_sayisi = $davet_row['davet_sayisi'] ?? 0;
        
        // Ödül bilgilerini veritabanından al
        $min_davet_sayisi = ayarAl('MIN_DAVET_SAYISI', 10);
        $freebet_miktar = ayarAl('FREEBET_MIKTARI', 200);
        $ekstra_odul_miktari = ayarAl('EKSTRA_ODUL_MIKTARI', 100);
        
        // Üst ödülleri JSON'dan çöz
        $ust_oduller_json = ayarAl('UST_ODULLER', '[{"sira":1,"odul":150000},{"sira":2,"odul":75000},{"sira":3,"odul":50000},{"sira":4,"odul":25000},{"sira":5,"odul":10000}]');
        $ust_oduller = json_decode($ust_oduller_json, true);
        
        // Toplam üst ödül miktarını hesapla
        $toplam_ust_odul = 0;
        foreach ($ust_oduller as $odul) {
            $toplam_ust_odul += $odul['odul'];
        }
        $ust_odul_sayisi = count($ust_oduller);
        
        // Üst ödüllerin detaylı listesini oluştur
        $ust_odul_detay = '';
        foreach ($ust_oduller as $odul) {
            if (isset($odul['sira']) && isset($odul['odul'])) {
                $emoji = '';
                switch ($odul['sira']) {
                    case 1: $emoji = '🥇'; break;
                    case 2: $emoji = '🥈'; break;
                    case 3: $emoji = '🥉'; break;
                    default: $emoji = '🏅'; break;
                }
                $ust_odul_detay .= "$emoji " . $odul['sira'] . ". sıra: " . number_format($odul['odul'], 0, ',', '.') . " TL\n";
            }
        }
        
        // Boşlukları temizle
        $ust_odul_detay = trim($ust_odul_detay);
        
        $mesaj = "👥 Davet Edilen Üye Sayısı: " . $davet_sayisi . "\n\n";
        $mesaj .= "Bu ekranı yenileyerek güncel davet ettiğin kişi sayısını görebilirsin\n\n";
        $mesaj .= "Bir kod hak edersen burada görüntülenecek:\n\n";
        $mesaj .= "Davet linkiniz:\n" . $row['davet_linki'];
        
        // Davet linkini kısalt (t.me formatı)
        $davet_linki = $row['davet_linki'];
        $kisa_link = str_replace("https://t.me/", "t.me/", $davet_linki);
        
        // Paylaşım metni
        $paylasim_metni = "🎮 BETPLAY DAVET TURNUVASI BAŞLADI! 🎮\n";
        $paylasim_metni .= "🔥 Beni BETPLAY'e sen de katıl ve birlikte kazanalım!\n\n";
        $paylasim_metni .= "💎 ÖDÜLLER:\n";
        $paylasim_metni .= "- En çok davet eden ilk " . $ust_odul_sayisi . " kişiye toplam " . number_format($toplam_ust_odul, 0, ',', '.') . " TL nakit!\n";
        $paylasim_metni .= $ust_odul_detay . "\n";
        $paylasim_metni .= "- Minimum " . $min_davet_sayisi . " arkadaş daveti = " . $freebet_miktar . " TL Freebet\n";
        $paylasim_metni .= "- Her ekstra davet için +" . $ekstra_odul_miktari . " TL bonus!\n";
        $paylasim_metni .= "- Sıralamaya gir, özel ödülleri kaçırma!\n\n";
        $paylasim_metni .= "📲 Hemen davetimi kabul et ve turnuvaya katıl:\n";
        $paylasim_metni .= "🎯 TIKLA KAZAN! 👉 " . $kisa_link;
        
        // Paylaş butonu ekle
        $klavye = [
            [['text' => '🎯 TIKLA KAZAN!', 'url' => 'https://t.me/share/url?url=' . urlencode($row['davet_linki']) . '&text=' . urlencode($paylasim_metni)]]
        ];
        
        $bot->mesajGonder($chat_id, $mesaj, '', false, null, ['inline_keyboard' => $klavye]);
        return true;
    } else {
        $bot->mesajGonder($chat_id, "⚠️ Bir hata oluştu. Lütfen tekrar deneyin.");
        return false;
    }
}

/**
 * Telefon numarası iste
 * 
 * @param BotAPI $bot Bot API nesnesi
 * @param int $chat_id Sohbet ID
 */
function telefonIsteFonk($bot, $chat_id) {
    // Telefon numarası paylaşma butonu
    $keyboard = [
        [
            [
                'text' => '📱 Telefon Numaramı Paylaş',
                'request_contact' => true
            ]
        ]
    ];
    
    $reply_markup = [
        'keyboard' => $keyboard,
        'resize_keyboard' => true,
        'one_time_keyboard' => true
    ];
    
    $mesaj = "🎁 *Etkinliğe Katılın ve Kazanmaya Başlayın!*\n\n";
    $mesaj .= "Etkinliğe katılmak ve özel davet linkinizi almak için lütfen aşağıdaki butondan telefon numaranızı paylaşın.\n\n";
    $mesaj .= "Telefon numaranız sadece etkinlik kapsamında kullanılacak ve üçüncü taraflarla paylaşılmayacaktır.";
    
    // Mesajı gönder
    $bot->mesajGonder($chat_id, $mesaj, 'Markdown', false, null, $reply_markup);
}

/**
 * Referans işle
 * 
 * @param BotAPI $bot Bot API nesnesi
 * @param int $chat_id Sohbet ID
 * @param array $kullanici Kullanıcı verisi
 * @param string $referans_kodu Referans kodu
 */
function referansIsle($bot, $chat_id, $kullanici, $referans_kodu) {
    global $vt;
    
    // Davet edeni referans koduna göre bul
    $stmt = $vt->prepare("SELECT id FROM kullanicilar WHERE davet_kodu = ?");
    $stmt->bind_param("s", $referans_kodu);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($row = $result->fetch_assoc()) {
        $davet_eden_id = $row['id'];
        
        // Davet edilenin ID'sini al
        $stmt = $vt->prepare("SELECT id FROM kullanicilar WHERE telegram_id = ?");
        $stmt->bind_param("i", $kullanici['id']);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($davet_edilen_row = $result->fetch_assoc()) {
            $davet_edilen_id = $davet_edilen_row['id'];
            
            // Bu davetin zaten var olup olmadığını kontrol et
            $stmt = $vt->prepare("SELECT id FROM davetler WHERE davet_eden_id = ? AND davet_edilen_id = ?");
            $stmt->bind_param("ii", $davet_eden_id, $davet_edilen_id);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows == 0) {
                // Karşılıklı davet kontrolü - B kişisi A'yı davet edemez
                $stmt = $vt->prepare("SELECT id FROM davetler WHERE davet_eden_id = ? AND davet_edilen_id = ?");
                $stmt->bind_param("ii", $davet_edilen_id, $davet_eden_id);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($result->num_rows > 0) {
                    // Karşılıklı davet tespit edildi
                    $bot->mesajGonder($chat_id, "⚠️ Sizi davet eden kişiyi tekrar davet edemezsiniz. Lütfen başka bir davet kodu kullanın.");
                } else {
                    // Daveti kaydet
                    $stmt = $vt->prepare("INSERT INTO davetler (davet_eden_id, davet_edilen_id, davet_tarihi, aktif) VALUES (?, ?, NOW(), TRUE)");
                    $stmt->bind_param("ii", $davet_eden_id, $davet_edilen_id);
                    $stmt->execute();
                    
                    // Davet edeni bilgilendir
                    $stmt = $vt->prepare("SELECT telegram_id FROM kullanicilar WHERE id = ?");
                    $stmt->bind_param("i", $davet_eden_id);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    
                    if ($davet_eden_row = $result->fetch_assoc()) {
                        $bot->mesajGonder(
                            $davet_eden_row['telegram_id'], 
                            "🎉 Tebrikler! Bir arkadaşınız davetinizi kabul etti. Güncel istatistiklerinizi görmek için /istatistiklerim komutunu kullanabilirsiniz."
                        );
                    }
                    
                    // Davet edilen kişiye teşvik mesajı gönder
                    tesvikMesajiGonder($bot, $chat_id, $kullanici['first_name'] ?? '');
                }
            }
        }
    }
    
    // Karşılama mesajını göster
    karsilamaGonder($bot, $chat_id);
}

/**
 * Lider tablosunu gönder
 * 
 * @param BotAPI $bot Bot API nesnesi
 * @param int $chat_id Sohbet ID
 */
function liderTablosuGonder($bot, $chat_id) {
    global $vt;
    
    // En çok davet edenleri al
    $sorgu = "
        SELECT 
            k.telegram_id,
            k.kullanici_adi,
            k.ad,
            k.soyad,
            COUNT(d.id) as davet_sayisi
        FROM 
            kullanicilar k
        LEFT JOIN 
            davetler d ON k.id = d.davet_eden_id AND d.aktif = TRUE
        GROUP BY 
            k.id
        ORDER BY 
            davet_sayisi DESC, MIN(d.davet_tarihi) ASC
        LIMIT 5
    ";
    
    $result = $vt->query($sorgu);
    
    $mesaj = "Liderlik Tablosu:\n\n";
    
    $sira = 1;
    while ($row = $result->fetch_assoc()) {
        // Gizlilik için telefon numaralarını maskele
        $maskeli_id = substr($row['telegram_id'], 0, 5) . '****';
        $referans_sayisi = $row['davet_sayisi'];
        
        $mesaj .= "$sira. $maskeli_id, Referans Kullanıcı: $referans_sayisi\n";
        $sira++;
    }
    
    $bot->mesajGonder($chat_id, $mesaj);
}

/**
 * Kullanıcı istatistiklerini gönder
 * 
 * @param BotAPI $bot Bot API nesnesi
 * @param int $chat_id Sohbet ID
 * @param int $telegram_id Telegram ID
 */
function istatistikGonder($bot, $chat_id, $telegram_id) {
    global $vt;
    
    // Kullanıcı bilgilerini al
    $kullanici_sorgu = $vt->prepare("SELECT * FROM kullanicilar WHERE telegram_id = ?");
    $kullanici_sorgu->bind_param("i", $telegram_id);
    $kullanici_sorgu->execute();
    $kullanici = $kullanici_sorgu->get_result()->fetch_assoc();
    
    if (!$kullanici) {
        $bot->mesajGonder($chat_id, "⚠️ Kullanıcı bilgileriniz bulunamadı. Lütfen /start komutunu göndererek tekrar başlayın.");
        return;
    }
    
    // Toplam davet sayısını al
    $davet_sorgu = $vt->prepare("
        SELECT COUNT(*) as toplam 
        FROM davetler 
        WHERE davet_eden_id = ? AND aktif = TRUE
    ");
    $davet_sorgu->bind_param("i", $kullanici['id']);
    $davet_sorgu->execute();
    $davet_sayisi = $davet_sorgu->get_result()->fetch_assoc()['toplam'];
    
    // Kullanıcının sıralamasını al
    $siralama_sorgu = $vt->query("
        SELECT k.id, k.telegram_id, COUNT(d.id) as davet_sayisi
        FROM kullanicilar k
        LEFT JOIN davetler d ON k.id = d.davet_eden_id AND d.aktif = TRUE
        GROUP BY k.id
        ORDER BY davet_sayisi DESC, k.kayit_tarihi ASC
    ");
    
    $kullanici_sira = 0;
    $sira = 1;
    
    while ($row = $siralama_sorgu->fetch_assoc()) {
        if ($row['id'] == $kullanici['id']) {
            $kullanici_sira = $sira;
            break;
        }
        $sira++;
    }
    
    // Ödül hesaplamaları
    $min_davet = minDavetSayisiAl();
    $freebet = ($davet_sayisi >= $min_davet) ? freebetMiktariAl() : 0;
    $ekstra_nakit = ($davet_sayisi > $min_davet) ? ($davet_sayisi - $min_davet) * ekstraOdulMiktariAl() : 0;
    
    // Kullanıcı adını belirle
    $kullanici_adi = $kullanici['kullanici_adi'] ?? '';
    $ad_soyad = trim(($kullanici['first_name'] ?? '') . ' ' . ($kullanici['last_name'] ?? ''));
    
    $kullanici_bilgisi = '';
    if (!empty($kullanici_adi)) {
        $kullanici_bilgisi = "@" . $kullanici_adi;
    } elseif (!empty($ad_soyad)) {
        $kullanici_bilgisi = $ad_soyad;
    } else {
        $kullanici_bilgisi = "Telegram Kullanıcısı #" . substr($telegram_id, -5);
    }
    
    // Mesajı oluştur
    $mesaj = "📊 *İSTATİSTİKLERİNİZ*\n\n";
    $mesaj .= "👤 Kullanıcı: " . $kullanici_bilgisi . "\n";
    $mesaj .= "🔢 Davet Sayısı: " . $davet_sayisi . "\n";
    $mesaj .= "🏆 Sıralama: " . $kullanici_sira . "\n\n";
    
    $mesaj .= "💰 *KAZANÇLARINIZ*\n";
    
    $toplam_kazanc = 0;
    
    if ($kullanici_sira <= 5 && $davet_sayisi > 0) {
        $ust_oduller = ayarAl('UST_ODULLER', '[{"sira":1,"odul":150000},{"sira":2,"odul":75000},{"sira":3,"odul":50000},{"sira":4,"odul":25000},{"sira":5,"odul":10000}]');
        $ust_oduller = json_decode($ust_oduller, true);
        if (isset($ust_oduller[$kullanici_sira-1])) {
            $odul_miktari = $ust_oduller[$kullanici_sira-1]['odul'];
            $mesaj .= "🥇 Sıralama Ödülü: " . number_format($odul_miktari, 0, ',', '.') . " TL\n";
            $toplam_kazanc += $odul_miktari;
        }
    }
    
    if ($freebet > 0) {
        $mesaj .= "🎁 Freebet: " . number_format($freebet, 0, ',', '.') . " TL\n";
        $toplam_kazanc += $freebet;
    }
    
    if ($ekstra_nakit > 0) {
        $mesaj .= "💵 Ekstra Nakit: " . number_format($ekstra_nakit, 0, ',', '.') . " TL\n";
        $toplam_kazanc += $ekstra_nakit;
    }
    
    // Toplam potansiyel kazanç
    $mesaj .= "\n💎 Toplam Potansiyel Kazanç: " . number_format($toplam_kazanc, 0, ',', '.') . " TL\n\n";
    $mesaj .= "ℹ️ Turnuva sonunda kazançlarınız Betplay hesabınıza aktarılacaktır.";
    
    $bot->mesajGonder($chat_id, $mesaj, 'Markdown');
}

/**
 * Turnuva kurallarını gönder
 * 
 * @param BotAPI $bot Bot API nesnesi
 * @param int $chat_id Sohbet ID
 */
function turnuvaKurallariGonder($bot, $chat_id) {
    $mesaj = turnuvaKurallariAl();
    
    if (empty($mesaj) || $mesaj == '📜 *BETPLAY TELEGRAM DAVET TURNUVASI KURALLARI*') {
        // Varsayılan kurallar
        $mesaj = "📜 *BETPLAY TELEGRAM DAVET TURNUVASI KURALLARI*\n\n";
        $mesaj .= "🗓 *Turnuva Tarihleri:* " . date('d.m.Y', strtotime(ayarAl('TURNUVA_BASLANGIC'))) . " - " . date('d.m.Y', strtotime(ayarAl('TURNUVA_BITIS'))) . "\n\n";
        
        $mesaj .= "🏆 *Ödüller:*\n";
        $ust_oduller = ayarAl('UST_ODULLER', '[{"sira":1,"odul":150000},{"sira":2,"odul":75000},{"sira":3,"odul":50000},{"sira":4,"odul":25000},{"sira":5,"odul":10000}]');
        $ust_oduller = json_decode($ust_oduller, true);
        foreach ($ust_oduller as $sira => $odul) {
            $mesaj .= "- " . $sira . ". olan: " . number_format($odul['odul'], 0, ',', '.') . " TL\n";
        }
        
        $mesaj .= "\n🎁 *Ekstra Ödüller:*\n";
        $mesaj .= "- En az " . minDavetSayisiAl() . " arkadaşını davet eden herkese: " . number_format(freebetMiktariAl(), 0, ',', '.') . " TL FREEBET\n";
        $mesaj .= "- " . minDavetSayisiAl() . " kişiden fazla her davet için: " . number_format(ekstraOdulMiktariAl(), 0, ',', '.') . " TL nakit\n\n";
        
        $mesaj .= "📋 *Katılım Şartları:*\n";
        $mesaj .= "1. Turnuvaya katılmak için Telegram hesabınız olmalıdır.\n";
        $mesaj .= "2. Zorunlu kanalları takip etmelisiniz.\n";
        $mesaj .= "3. Telefon numaranızı paylaşmalısınız.\n";
        $mesaj .= "4. Davet ettiğiniz kişiler botla etkileşime geçmelidir.\n\n";
        
        $mesaj .= "⚠️ *Önemli Notlar:*\n";
        $mesaj .= "- Sahte hesaplar ile yapılan davetler geçersiz sayılacaktır.\n";
        $mesaj .= "- Ödüller turnuva bitiminde hesaplara aktarılacaktır.\n";
        $mesaj .= "- Herhangi bir anlaşmazlık durumunda Betplay'in kararı geçerlidir.";
    }
    
    $bot->mesajGonder($chat_id, $mesaj, 'Markdown');
}

/**
 * Yardım mesajını gönder
 * 
 * @param BotAPI $bot Bot API nesnesi
 * @param int $chat_id Sohbet ID
 */
function yardimGonder($bot, $chat_id) {
    $mesaj = "📋 *BETPLAY TELEGRAM DAVET TURNUVASI BOT KOMUTLARI*\n\n";
    $mesaj .= "/start - Botu başlat ve ana menüyü görüntüle\n";
    $mesaj .= "/yardim - Bu yardım mesajını görüntüle\n";
    $mesaj .= "/lidertablosu - Turnuva lider tablosunu görüntüle\n";
    $mesaj .= "/istatistiklerim - Kişisel davet istatistiklerinizi görüntüle\n\n";
    
    $mesaj .= "Davet turnuvasına katılmak için ana menüden 'TIKLA HEMEN KAZANMAYA BAŞLA' butonuna tıklayın ve özel davet linkinizi alın.";
    
    $bot->mesajGonder($chat_id, $mesaj, 'markdown');
}

/**
 * Sohbet katılma isteklerini işle
 * 
 * @param BotAPI $bot Bot API nesnesi
 * @param array $istek İstek verisi
 */
function katilmaIstegiIsleme($bot, $istek) {
    global $vt;
    
    // Kullanılan davet bağlantısını al
    $davet_linki = $istek['invite_link']['invite_link'] ?? '';
    
    // Davet edeni davet bağlantısından bul
    $stmt = $vt->prepare("SELECT id, telegram_id FROM kullanicilar WHERE davet_linki = ?");
    $stmt->bind_param("s", $davet_linki);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $davet_eden_id = $row['id'];
        $davet_eden_telegram_id = $row['telegram_id'];
        
        // Davet edileni kaydet
        $davet_edilen_id = $istek['from']['id'];
        
        // Daha önce davet edilmiş mi kontrol et
        $kontrol = $vt->prepare("SELECT id FROM davetler WHERE davet_edilen_id = ?");
        $kontrol->bind_param("i", $davet_edilen_id);
        $kontrol->execute();
        
        if ($kontrol->get_result()->num_rows == 0) {
            // Yeni davet kaydı oluştur
            $stmt = $vt->prepare("INSERT INTO davetler (davet_eden_id, davet_edilen_id, davet_tarihi) VALUES (?, ?, NOW())");
            $stmt->bind_param("ii", $davet_eden_id, $davet_edilen_id);
            $stmt->execute();
            
            // Zorunlu kanalları al
            $zorunlu_kanallar = zorunluKanallariGetir();
            
            // Eğer zorunlu kanal varsa, ilk kanala katılma isteğini onayla
            if (!empty($zorunlu_kanallar)) {
                $bot->katilmaIstegiOnayla($zorunlu_kanallar[0], $istek['from']['id']);
            }
            
            // Davet edeni bilgilendir
            $bot->mesajGonder($davet_eden_telegram_id, "🎉 Tebrikler! Bir arkadaşınız davetinizi kabul etti. Güncel istatistiklerinizi görmek için /istatistiklerim komutunu kullanabilirsiniz.");
            
            // Davet edilen kişiye teşvik mesajı gönder
            $davet_edilen_ad = $istek['from']['first_name'] ?? '';
            
            // Davet edilen kullanıcıyı veritabanına kaydet (eğer yoksa)
            $kullanici_kontrol = $vt->prepare("SELECT id FROM kullanicilar WHERE telegram_id = ?");
            $kullanici_kontrol->bind_param("i", $davet_edilen_id);
            $kullanici_kontrol->execute();
            $kullanici_sonuc = $kullanici_kontrol->get_result();
            
            if ($kullanici_sonuc->num_rows == 0) {
                // Kullanıcı bilgilerini kaydet
                $kullanici_adi = $istek['from']['username'] ?? '';
                $ad = $istek['from']['first_name'] ?? '';
                $soyad = $istek['from']['last_name'] ?? '';
                
                $davet_kodu = generateRandomString(8);
                $davet_linki = 'https://t.me/' . BOT_KULLANICI_ADI . '?start=' . $davet_kodu;
                
                $kullanici_ekle = $vt->prepare("INSERT INTO kullanicilar (telegram_id, kullanici_adi, ad, soyad, davet_kodu, davet_linki, kayit_tarihi) VALUES (?, ?, ?, ?, ?, ?, NOW())");
                $kullanici_ekle->bind_param("isssss", $davet_edilen_id, $kullanici_adi, $ad, $soyad, $davet_kodu, $davet_linki);
                $kullanici_ekle->execute();
            }
            
            // Katılma isteğini onayla
            $bot->katilmaIstegiOnayla($istek['chat']['id'], $davet_edilen_id);
            
            // Davet edilen kişiye teşvik mesajı gönder
            tesvikMesajiGonder($bot, $davet_edilen_id, $davet_edilen_ad);
        }
    }
}

/**
 * Sohbet üyesi güncellemelerini işle (katılma/ayrılma)
 * 
 * @param BotAPI $bot Bot API nesnesi
 * @param array $guncelleme Güncelleme verisi
 */
function sohbetUyesiGuncellemeIsleme($bot, $guncelleme) {
    global $vt;
    
    $user_id = $guncelleme['new_chat_member']['user']['id'];
    $durum = $guncelleme['new_chat_member']['status'];
    
    // Kullanıcı kanaldan ayrıldıysa
    if ($durum == 'left' || $durum == 'kicked') {
        // Davet kaydını bul ve pasif olarak işaretle
        $stmt = $vt->prepare("
            UPDATE davetler d
            JOIN kullanicilar k ON d.davet_edilen_id = k.id
            SET d.aktif = FALSE
            WHERE k.telegram_id = ?
        ");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        
        // Kullanıcı durumunu güncelle
        $stmt = $vt->prepare("UPDATE kullanicilar SET aktif = FALSE WHERE telegram_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        
        // Davet edeni bul
        $stmt = $vt->prepare("
            SELECT k.telegram_id 
            FROM davetler d
            JOIN kullanicilar k ON d.davet_eden_id = k.id
            JOIN kullanicilar k2 ON d.davet_edilen_id = k2.id
            WHERE k2.telegram_id = ?
        ");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($row = $result->fetch_assoc()) {
            // Davet edeni bilgilendir
            $bot->mesajGonder($row['telegram_id'], "⚠️ Davet ettiğiniz bir kullanıcı kanaldan ayrıldı. Bu, sıralamanızı etkileyebilir.");
        }
    }
}

/**
 * Davet edilen kişiye teşvik mesajı gönder
 * 
 * @param BotAPI $bot Bot API nesnesi
 * @param int $chat_id Sohbet ID
 * @param string $ad Kullanıcı adı
 */
function tesvikMesajiGonder($bot, $chat_id, $ad) {
    global $vt;
    
    // Ayarlardan değerleri al - ayar isimlerini admin paneli ile uyumlu hale getirdik
    $freebet_min_davet = ayarAl('MIN_DAVET_SAYISI', 5);
    $freebet_miktar = ayarAl('FREEBET_MIKTARI', 500);
    $ekstra_davet_miktar = ayarAl('EKSTRA_ODUL_MIKTARI', 100);
    $turnuva_bitis = ayarAl('TURNUVA_BITIS', '2025-05-03 23:59:59');
    
    // Bitiş tarihini formatlı göster
    $bitis_tarihi = date('d.m.Y', strtotime($turnuva_bitis));
    
    // Üst ödülleri al - config.php'deki fonksiyonu kullan
    $ust_oduller_json = ayarAl('UST_ODULLER', '[{"sira":1,"odul":150000},{"sira":2,"odul":75000},{"sira":3,"odul":50000},{"sira":4,"odul":25000},{"sira":5,"odul":10000}]');
    $ust_oduller = json_decode($ust_oduller_json, true);
    $ust_odul_sayisi = count($ust_oduller);
    $ust_odul_metni = "✅ En çok davet eden ilk {$ust_odul_sayisi} kişiye büyük nakit ödüller:\n";
    foreach ($ust_oduller as $odul) {
        if (isset($odul['sira']) && isset($odul['odul'])) {
            $ust_odul_metni .= "🥇 " . $odul['sira'] . ". sıra: " . number_format($odul['odul'], 0, ',', '.') . " TL\n";
        }
    }
    
    // Teşvik mesajını oluştur
    $tesvikMesaji = "🎉 *Hoş Geldiniz $ad!* 🎉\n\n";
    $tesvikMesaji .= "Betplay Davet Turnuvası'na katıldığınız için teşekkür ederiz!\n\n";
    $tesvikMesaji .= "🎁 *Siz de Kazanmaya Başlayın!*\n";
    $tesvikMesaji .= "Arkadaşlarınızı davet ederek siz de hemen kazanmaya başlayabilirsiniz:\n";
    $tesvikMesaji .= "✅ En az {$freebet_min_davet} arkadaşınızı davet edin ve {$freebet_miktar} TL Freebet kazanın\n";
    $tesvikMesaji .= "✅ {$freebet_min_davet}'ten fazla her davet için {$ekstra_davet_miktar} TL nakit ödül\n";
    $tesvikMesaji .= $ust_odul_metni . "\n";
    $tesvikMesaji .= "📱 Kendi davet linkinizi almak için bana /start komutunu gönderin ve talimatları izleyin.\n\n";
    $tesvikMesaji .= "🏆 Turnuva {$bitis_tarihi} tarihine kadar devam edecektir. Şimdiden bol şanslar!";
    
    // Mesajı doğrudan göndermeyi dene
    try {
        $bot->mesajGonder($chat_id, $tesvikMesaji, 'Markdown');
    } catch (Exception $e) {
        // Hata durumunda bildirimlere ekle
        $bildirim_ekle = $vt->prepare("INSERT INTO bildirimler (telegram_id, mesaj, gonderildi, olusturma_tarihi) VALUES (?, ?, 0, NOW())");
        $bildirim_ekle->bind_param("is", $chat_id, $tesvikMesaji);
        $bildirim_ekle->execute();
    }
}
?>
