<?php
// Bot Yapılandırması
define('BOT_TOKEN', '7648148330:AAHeUNRCkA4C59HL-5xqt-nu4zgk50lpnxE');
define('BOT_KULLANICI_ADI', '@betplayetkinlik_bot');

// Veritabanı Yapılandırması
define('VT_HOST', 'localhost');
define('VT_KULLANICI', 'guncoqte_play'); // MAMP'in varsayılan kullanıcı adı
define('VT_SIFRE', '2261825qqW.'); // MAMP'in varsayılan şifresi
define('VT_ISIM', 'guncoqte_play');

// Veritabanı bağlantısı
$vt = new mysqli(VT_HOST, VT_KULLANICI, VT_SIFRE, VT_ISIM);
if ($vt->connect_error) {
    die("Bağlantı hatası: " . $vt->connect_error);
}
$vt->set_charset("utf8mb4");

// Ayarları veritabanından al
$ayarlar = [];
$ayarlar_sorgu = $vt->query("SELECT anahtar, deger FROM ayarlar");
if ($ayarlar_sorgu) {
    while ($row = $ayarlar_sorgu->fetch_assoc()) {
        $ayarlar[$row['anahtar']] = $row['deger'];
    }
}

// Kayıt site URL'si
define('KAYIT_URL', 'https://betplay.com/kayit');

/**
 * Ayarı al
 * 
 * @param string $anahtar Ayar anahtarı
 * @param mixed $varsayilan Varsayılan değer
 * @return mixed Ayar değeri
 */
function ayarAl($anahtar, $varsayilan = null) {
    global $ayarlar;
    return isset($ayarlar[$anahtar]) ? $ayarlar[$anahtar] : $varsayilan;
}

/**
 * Turnuvanın aktif olup olmadığını kontrol et
 * 
 * @return bool Turnuva aktif mi
 */
function turnuvaAktifMi() {
    $simdi = date('Y-m-d H:i:s');
    $baslangic = ayarAl('TURNUVA_BASLANGIC', '2025-04-23 00:01:00');
    $bitis = ayarAl('TURNUVA_BITIS', '2025-05-03 23:59:59');
    
    return ($simdi >= $baslangic && $simdi <= $bitis);
}

/**
 * Üst ödülleri al
 * 
 * @return array Üst ödüller
 */
function ustOdulleriAl() {
    $ust_oduller_json = ayarAl('UST_ODULLER', '[{"sira":1,"odul":150000},{"sira":2,"odul":75000},{"sira":3,"odul":50000},{"sira":4,"odul":25000},{"sira":5,"odul":10000}]');
    return json_decode($ust_oduller_json, true);
}

/**
 * Minimum davet sayısını al
 * 
 * @return int Minimum davet sayısı
 */
function minDavetSayisiAl() {
    return (int)ayarAl('MIN_DAVET_SAYISI', 5);
}

/**
 * Freebet miktarını al
 * 
 * @return int Freebet miktarı
 */
function freebetMiktariAl() {
    return (int)ayarAl('FREEBET_MIKTARI', 500);
}

/**
 * Ekstra ödül miktarını al
 * 
 * @return int Ekstra ödül miktarı
 */
function ekstraOdulMiktariAl() {
    return (int)ayarAl('EKSTRA_ODUL_MIKTARI', 100);
}

/**
 * Turnuva kurallarını al
 * 
 * @return string Turnuva kuralları
 */
function turnuvaKurallariAl() {
    return ayarAl('TURNUVA_KURALLARI', '📜 *BETPLAY TELEGRAM DAVET TURNUVASI KURALLARI*');
}
?>
