<?php
/**
 * Betplay Davet Turnuvası - Turnuva Bitiş Kontrolü
 * Bu script, turnuvanın bitip bitmediğini kontrol eder ve bitmiş ise ödülleri otomatik dağıtır
 * Cron job ile her gün çalıştırılabilir (örn: 00:05'te)
 */
require_once '../bot/config.php';

// Log dosyası
$log_file = 'turnuva_kontrol_log.txt';
file_put_contents($log_file, "Turnuva kontrol başladı - " . date('Y-m-d H:i:s') . "\n", FILE_APPEND);

// Turnuva bitiş tarihini al
$bitis_tarihi = ayarAl('TURNUVA_BITIS', '2025-05-03 23:59:59');
$simdi = date('Y-m-d H:i:s');

file_put_contents($log_file, "Turnuva bitiş tarihi: $bitis_tarihi, Şimdi: $simdi\n", FILE_APPEND);

// Turnuva bitti mi kontrol et
if ($simdi > $bitis_tarihi) {
    // Turnuva bitmiş, ödüllerin dağıtılıp dağıtılmadığını kontrol et
    $odul_dagitim_yapildi = ayarAl('ODUL_DAGITIM_YAPILDI', 'hayir');
    
    if ($odul_dagitim_yapildi != 'evet') {
        file_put_contents($log_file, "Turnuva bitmiş ve ödül dağıtımı yapılmamış. Ödül dağıtımı başlatılıyor...\n", FILE_APPEND);
        
        // Ödül dağıtım scriptini çağır
        include_once 'odul_dagitim_islem.php';
        
        // Ödül dağıtımı yapıldı olarak işaretle
        $vt->query("INSERT INTO ayarlar (anahtar, deger) VALUES ('ODUL_DAGITIM_YAPILDI', 'evet') 
                   ON DUPLICATE KEY UPDATE deger = 'evet'");
        
        file_put_contents($log_file, "Ödül dağıtımı tamamlandı ve işaretlendi.\n", FILE_APPEND);
    } else {
        file_put_contents($log_file, "Turnuva bitmiş fakat ödül dağıtımı daha önce yapılmış.\n", FILE_APPEND);
    }
} else {
    file_put_contents($log_file, "Turnuva henüz bitmemiş. Ödül dağıtımı yapılmayacak.\n", FILE_APPEND);
}

file_put_contents($log_file, "Turnuva kontrol tamamlandı - " . date('Y-m-d H:i:s') . "\n", FILE_APPEND);
?>
