<?php
/**
 * Betplay Davet Turnuvası - Yönetim Paneli
 * Ödüller Sayfası
 */
require_once '../bot/config.php';
require_once 'includes/header.php';

// Sayfalama için değişkenler
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$limit = 20;
$offset = ($sayfa - 1) * $limit;

// Arama filtresi
$arama = isset($_GET['arama']) ? $vt->real_escape_string($_GET['arama']) : '';
$arama_filtresi = '';
if (!empty($arama)) {
    $arama_filtresi = " WHERE 
        k.telegram_id LIKE '%$arama%' OR 
        k.kullanici_adi LIKE '%$arama%'";
}

// Toplam ödül sayısını al
$toplam_sorgu = "
    SELECT COUNT(*) as toplam 
    FROM oduller o
    JOIN kullanicilar k ON o.kullanici_id = k.id
    $arama_filtresi
";
$toplam_sonuc = $vt->query($toplam_sorgu);
$toplam_satir = $toplam_sonuc->fetch_assoc()['toplam'];
$toplam_sayfa = ceil($toplam_satir / $limit);

// Ödülleri al
$oduller_sorgu = "
    SELECT 
        o.*,
        k.telegram_id,
        k.kullanici_adi,
        k.ad,
        k.soyad
    FROM 
        oduller o
    JOIN 
        kullanicilar k ON o.kullanici_id = k.id
    $arama_filtresi
    ORDER BY 
        o.olusturma_tarihi DESC
    LIMIT $offset, $limit
";
$oduller = $vt->query($oduller_sorgu);

// Ödül silme işlemi
if (isset($_POST['sil']) && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $vt->query("DELETE FROM oduller WHERE id = $id");
    header('Location: oduller.php');
    exit;
}

// Ödül durumunu değiştirme
if (isset($_POST['durum_degistir']) && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $yeni_durum = $vt->real_escape_string($_POST['yeni_durum']);
    $vt->query("UPDATE oduller SET durum = '$yeni_durum' WHERE id = $id");
    header('Location: oduller.php');
    exit;
}

// Ödül ekleme
$mesaj = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ekle'])) {
    $kullanici_id = (int)$_POST['kullanici_id'];
    $odul_tipi = $vt->real_escape_string($_POST['odul_tipi']);
    $miktar = (float)$_POST['miktar'];
    $durum = $vt->real_escape_string($_POST['durum']);
    
    $vt->query("INSERT INTO oduller (kullanici_id, odul_tipi, miktar, durum, olusturma_tarihi) VALUES ($kullanici_id, '$odul_tipi', $miktar, '$durum', NOW())");
    
    if ($vt->affected_rows > 0) {
        $mesaj = '<div class="alert alert-success">Ödül başarıyla eklendi!</div>';
    } else {
        $mesaj = '<div class="alert alert-danger">Ödül eklenirken bir hata oluştu!</div>';
    }
}

// Kullanıcıları al (ödül eklemek için)
$kullanicilar_sorgu = "
    SELECT 
        k.id,
        k.telegram_id,
        k.kullanici_adi,
        k.ad,
        k.soyad,
        COUNT(d.id) as davet_sayisi
    FROM 
        kullanicilar k
    LEFT JOIN 
        davetler d ON k.id = d.davet_eden_id AND d.aktif = TRUE
    GROUP BY 
        k.id
    ORDER BY 
        davet_sayisi DESC
    LIMIT 100
";
$kullanicilar = $vt->query($kullanicilar_sorgu);
$kullanicilar_listesi = [];
while ($kullanici = $kullanicilar->fetch_assoc()) {
    $kullanicilar_listesi[] = $kullanici;
}

// Kullanıcıya mesaj gönderme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['mesaj_gonder'])) {
    require_once '../bot/BotAPI.php';
    $bot = new BotAPI(BOT_TOKEN);
    
    $telegram_id = (int)$_POST['telegram_id'];
    $mesaj_metni = $vt->real_escape_string($_POST['mesaj_metni']);
    $promo_kod = $vt->real_escape_string($_POST['promo_kod'] ?? '');
    
    // Mesaj içeriğini hazırla
    $telegram_mesaji = $mesaj_metni;
    
    if (!empty($promo_kod)) {
        $telegram_mesaji .= "\n\n🎟️ *Promo Kodunuz:* `" . $promo_kod . "`";
    }
    
    // Mesajı gönder
    try {
        $bot->mesajGonder($telegram_id, $telegram_mesaji, 'Markdown');
        $mesaj = '<div class="alert alert-success">Mesaj başarıyla gönderildi!</div>';
        
        // Mesaj logunu kaydet
        $vt->query("INSERT INTO mesaj_log (telegram_id, mesaj, promo_kod, gonderim_tarihi) VALUES ($telegram_id, '$mesaj_metni', '$promo_kod', NOW())");
    } catch (Exception $e) {
        $mesaj = '<div class="alert alert-danger">Mesaj gönderilirken bir hata oluştu: ' . $e->getMessage() . '</div>';
    }
}
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Ödüller</h1>
        <div class="d-flex">
            <form class="form-inline mr-2">
                <div class="input-group">
                    <input type="text" class="form-control" placeholder="Ara..." name="arama" value="<?php echo htmlspecialchars($arama); ?>">
                    <div class="input-group-append">
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
            </form>
            <a href="odul_dagitim.php" class="btn btn-warning mr-2">
                <i class="fas fa-trophy"></i> Otomatik Ödül Dağıt
            </a>
            <button type="button" class="btn btn-success" data-toggle="modal" data-target="#odulEkleModal">
                <i class="fas fa-plus"></i> Ödül Ekle
            </button>
        </div>
    </div>
    
    <?php echo $mesaj; ?>
    
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Kullanıcı</th>
                            <th>Ödül Tipi</th>
                            <th>Miktar</th>
                            <th>Durum</th>
                            <th>Oluşturma Tarihi</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($odul = $oduller->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $odul['id']; ?></td>
                                <td>
                                    <?php if (!empty($odul['kullanici_adi'])): ?>
                                        @<?php echo htmlspecialchars($odul['kullanici_adi']); ?>
                                    <?php else: ?>
                                        <?php echo htmlspecialchars($odul['ad'] . ' ' . $odul['soyad']); ?>
                                    <?php endif; ?>
                                    <br>
                                    <small class="text-muted">ID: <?php echo $odul['telegram_id']; ?></small>
                                </td>
                                <td>
                                    <?php if ($odul['odul_tipi'] == 'NAKIT'): ?>
                                        <span class="badge badge-success">NAKİT</span>
                                    <?php else: ?>
                                        <span class="badge badge-info">FREEBET</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo number_format($odul['miktar'], 2, ',', '.'); ?> TL</td>
                                <td>
                                    <?php if ($odul['durum'] == 'BEKLEMEDE'): ?>
                                        <span class="badge badge-warning">BEKLEMEDE</span>
                                    <?php elseif ($odul['durum'] == 'DAGITILDI'): ?>
                                        <span class="badge badge-success">DAĞITILDI</span>
                                    <?php else: ?>
                                        <span class="badge badge-info">ALINDI</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo date('d.m.Y H:i', strtotime($odul['olusturma_tarihi'])); ?></td>
                                <td>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-sm btn-primary dropdown-toggle" data-toggle="dropdown">
                                            Durum Değiştir
                                        </button>
                                        <div class="dropdown-menu">
                                            <form method="post">
                                                <input type="hidden" name="id" value="<?php echo $odul['id']; ?>">
                                                <input type="hidden" name="yeni_durum" value="BEKLEMEDE">
                                                <button type="submit" name="durum_degistir" class="dropdown-item">BEKLEMEDE</button>
                                            </form>
                                            <form method="post">
                                                <input type="hidden" name="id" value="<?php echo $odul['id']; ?>">
                                                <input type="hidden" name="yeni_durum" value="DAGITILDI">
                                                <button type="submit" name="durum_degistir" class="dropdown-item">DAĞITILDI</button>
                                            </form>
                                            <form method="post">
                                                <input type="hidden" name="id" value="<?php echo $odul['id']; ?>">
                                                <input type="hidden" name="yeni_durum" value="ALINDI">
                                                <button type="submit" name="durum_degistir" class="dropdown-item">ALINDI</button>
                                            </form>
                                        </div>
                                        <form method="post" class="d-inline" onsubmit="return confirm('Bu ödülü silmek istediğinize emin misiniz?');">
                                            <input type="hidden" name="id" value="<?php echo $odul['id']; ?>">
                                            <button type="submit" name="sil" class="btn btn-sm btn-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                        <button type="button" class="btn btn-sm btn-info" onclick="mesajModalAc(<?php echo $odul['telegram_id']; ?>, '<?php echo !empty($odul['kullanici_adi']) ? '@' . htmlspecialchars($odul['kullanici_adi']) : htmlspecialchars($odul['ad'] . ' ' . $odul['soyad']); ?>')">
                                            <i class="fas fa-envelope"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if ($toplam_sayfa > 1): ?>
                <nav>
                    <ul class="pagination justify-content-center">
                        <?php if ($sayfa > 1): ?>
                            <li class="page-item">
                                <a class="page-link" href="?sayfa=<?php echo $sayfa - 1; ?><?php echo !empty($arama) ? '&arama=' . urlencode($arama) : ''; ?>">
                                    <i class="fas fa-chevron-left"></i>
                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <?php for ($i = max(1, $sayfa - 2); $i <= min($toplam_sayfa, $sayfa + 2); $i++): ?>
                            <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                                <a class="page-link" href="?sayfa=<?php echo $i; ?><?php echo !empty($arama) ? '&arama=' . urlencode($arama) : ''; ?>">
                                    <?php echo $i; ?>
                                </a>
                            </li>
                        <?php endfor; ?>
                        
                        <?php if ($sayfa < $toplam_sayfa): ?>
                            <li class="page-item">
                                <a class="page-link" href="?sayfa=<?php echo $sayfa + 1; ?><?php echo !empty($arama) ? '&arama=' . urlencode($arama) : ''; ?>">
                                    <i class="fas fa-chevron-right"></i>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Ödül Ekle Modal -->
<div class="modal fade" id="odulEkleModal" tabindex="-1" role="dialog" aria-labelledby="odulEkleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="odulEkleModalLabel">Ödül Ekle</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Kapat">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="kullanici_id">Kullanıcı</label>
                        <select class="form-control" id="kullanici_id" name="kullanici_id" required>
                            <option value="">Kullanıcı Seçin</option>
                            <?php foreach ($kullanicilar_listesi as $kullanici): ?>
                                <option value="<?php echo $kullanici['id']; ?>">
                                    <?php if (!empty($kullanici['kullanici_adi'])): ?>
                                        @<?php echo htmlspecialchars($kullanici['kullanici_adi']); ?>
                                    <?php else: ?>
                                        <?php echo htmlspecialchars($kullanici['ad'] . ' ' . $kullanici['soyad']); ?>
                                    <?php endif; ?>
                                    (ID: <?php echo $kullanici['telegram_id']; ?>, Davet: <?php echo $kullanici['davet_sayisi']; ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="odul_tipi">Ödül Tipi</label>
                        <select class="form-control" id="odul_tipi" name="odul_tipi" required>
                            <option value="NAKIT">NAKİT</option>
                            <option value="FREEBET">FREEBET</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="miktar">Miktar (TL)</label>
                        <input type="number" class="form-control" id="miktar" name="miktar" step="0.01" required>
                    </div>
                    <div class="form-group">
                        <label for="durum">Durum</label>
                        <select class="form-control" id="durum" name="durum" required>
                            <option value="BEKLEMEDE">BEKLEMEDE</option>
                            <option value="DAGITILDI">DAĞITILDI</option>
                            <option value="ALINDI">ALINDI</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">İptal</button>
                    <button type="submit" name="ekle" class="btn btn-primary">Ekle</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Mesaj Gönder Modal -->
<div class="modal fade" id="mesajGonderModal" tabindex="-1" role="dialog" aria-labelledby="mesajGonderModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="mesajGonderModalLabel">Mesaj Gönder</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Kapat">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="mesaj_metni">Mesaj Metni</label>
                        <textarea class="form-control" id="mesaj_metni" name="mesaj_metni" required></textarea>
                    </div>
                    <div class="form-group">
                        <label for="promo_kod">Promo Kod (isteğe bağlı)</label>
                        <input type="text" class="form-control" id="promo_kod" name="promo_kod">
                    </div>
                    <input type="hidden" name="telegram_id" id="telegram_id">
                    <input type="hidden" name="kullanici_adi" id="kullanici_adi">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">İptal</button>
                    <button type="submit" name="mesaj_gonder" class="btn btn-primary">Gönder</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function mesajModalAc(telegram_id, kullanici_adi) {
        $('#telegram_id').val(telegram_id);
        $('#kullanici_adi').val(kullanici_adi);
        $('#mesajGonderModal').modal('show');
    }
</script>

<?php require_once 'includes/footer.php'; ?>
