<?php
/**
 * Betplay Davet Turnuvası - Otomatik Ödül Dağıtım Scripti
 * Bu script, turnuva bitiminde otomatik olarak ödülleri hesaplar ve dağıtır
 */
require_once '../bot/config.php';
require_once '../bot/BotAPI.php';
require_once '../bot/fonksiyonlar.php';
require_once '../bot/fonksiyonlar2.php';

// Yönetici kontrolü
session_start();
if (!isset($_SESSION['yonetici_id'])) {
    header('Location: giris.php');
    exit;
}

// Bot başlat
$bot = new BotAPI(BOT_TOKEN);

// Log dosyası
$log_file = 'odul_dagitim_log.txt';
file_put_contents($log_file, "Ödül dağıtım başladı - " . date('Y-m-d H:i:s') . "\n", FILE_APPEND);

// Turnuva aktif mi kontrol et
if (turnuvaAktifMi()) {
    $mesaj = '<div class="alert alert-warning">Turnuva hala devam ediyor! Ödül dağıtımı için turnuvanın bitmesini bekleyin.</div>';
    file_put_contents($log_file, "Turnuva hala devam ediyor - " . date('Y-m-d H:i:s') . "\n", FILE_APPEND);
} else {
    // Tüm kullanıcıları ve davet sayılarını al
    $kullanicilar_sorgu = "
        SELECT 
            k.id,
            k.telegram_id,
            k.kullanici_adi,
            k.ad,
            k.soyad,
            COUNT(d.id) as davet_sayisi,
            MIN(d.davet_tarihi) as ilk_davet_tarihi
        FROM 
            kullanicilar k
        LEFT JOIN 
            davetler d ON k.id = d.davet_eden_id AND d.aktif = TRUE
        GROUP BY 
            k.id
        ORDER BY 
            COUNT(d.id) DESC, 
            MIN(d.davet_tarihi) ASC
    ";
    $kullanicilar = $vt->query($kullanicilar_sorgu);
    
    // Ödül dağıtımı için değişkenler
    $min_davet = minDavetSayisiAl();
    $freebet_miktari = freebetMiktariAl();
    $ekstra_odul_miktari = ekstraOdulMiktariAl();
    $ust_oduller = ustOdulleriAl();
    
    // Dağıtılan ödülleri say
    $dagitilan_odul_sayisi = 0;
    $hata_sayisi = 0;
    
    // Kullanıcı sıralaması
    $sira = 1;
    
    // Her kullanıcı için ödül hesapla ve ekle
    while ($kullanici = $kullanicilar->fetch_assoc()) {
        $kullanici_id = $kullanici['id'];
        $telegram_id = $kullanici['telegram_id'];
        $davet_sayisi = $kullanici['davet_sayisi'];
        $kullanici_adi = !empty($kullanici['kullanici_adi']) ? '@' . $kullanici['kullanici_adi'] : $kullanici['ad'] . ' ' . $kullanici['soyad'];
        
        // Ödül hesaplamalarını yap
        $oduller = [];
        
        // 1. Üst sıralama ödülü (ilk 5)
        if ($sira <= 5 && $davet_sayisi > 0) {
            foreach ($ust_oduller as $odul) {
                if ($odul['sira'] == $sira) {
                    $oduller[] = [
                        'tip' => 'NAKIT',
                        'miktar' => $odul['odul'],
                        'aciklama' => "Turnuva $sira. sıra ödülü"
                    ];
                    break;
                }
            }
        }
        
        // 2. Minimum davet sayısına ulaşanlara freebet
        if ($davet_sayisi >= $min_davet) {
            $oduller[] = [
                'tip' => 'FREEBET',
                'miktar' => $freebet_miktari,
                'aciklama' => "Minimum $min_davet davet freebet ödülü"
            ];
        }
        
        // 3. Ekstra davet ödülü
        if ($davet_sayisi > $min_davet) {
            $ekstra_davet = $davet_sayisi - $min_davet;
            $ekstra_odul = $ekstra_davet * $ekstra_odul_miktari;
            
            $oduller[] = [
                'tip' => 'NAKIT',
                'miktar' => $ekstra_odul,
                'aciklama' => "Ekstra $ekstra_davet davet için nakit ödül"
            ];
        }
        
        // Ödülleri veritabanına ekle
        foreach ($oduller as $odul) {
            // Önceden eklenmiş mi kontrol et
            $kontrol_sorgu = $vt->prepare("
                SELECT id FROM oduller 
                WHERE kullanici_id = ? AND odul_tipi = ? AND miktar = ? AND aciklama = ?
            ");
            $kontrol_sorgu->bind_param("isds", $kullanici_id, $odul['tip'], $odul['miktar'], $odul['aciklama']);
            $kontrol_sorgu->execute();
            $kontrol_sonuc = $kontrol_sorgu->get_result();
            
            if ($kontrol_sonuc->num_rows == 0) {
                // Ödülü ekle
                $ekle_sorgu = $vt->prepare("
                    INSERT INTO oduller (kullanici_id, odul_tipi, miktar, durum, aciklama, olusturma_tarihi) 
                    VALUES (?, ?, ?, 'BEKLEMEDE', ?, NOW())
                ");
                $ekle_sorgu->bind_param("isds", $kullanici_id, $odul['tip'], $odul['miktar'], $odul['aciklama']);
                
                if ($ekle_sorgu->execute()) {
                    $dagitilan_odul_sayisi++;
                    
                    // Log
                    $log_mesaj = "Ödül eklendi - Kullanıcı: $kullanici_adi, Tip: {$odul['tip']}, Miktar: {$odul['miktar']}, Açıklama: {$odul['aciklama']}\n";
                    file_put_contents($log_file, $log_mesaj, FILE_APPEND);
                    
                    // Kullanıcıya bildirim gönder
                    try {
                        $bildirim_mesaji = "🏆 *Tebrikler!* Turnuva ödülünüz tanımlandı!\n\n";
                        $bildirim_mesaji .= "🎁 Ödül: *" . number_format($odul['miktar'], 0, ',', '.') . " TL " . ($odul['tip'] == 'NAKIT' ? 'Nakit' : 'Freebet') . "*\n";
                        $bildirim_mesaji .= "📝 Açıklama: " . $odul['aciklama'] . "\n\n";
                        $bildirim_mesaji .= "💰 Ödülünüz hesabınıza en kısa sürede tanımlanacaktır.";
                        
                        $bot->mesajGonder($telegram_id, $bildirim_mesaji, 'Markdown');
                    } catch (Exception $e) {
                        file_put_contents($log_file, "Bildirim hatası - Kullanıcı: $kullanici_adi, Hata: " . $e->getMessage() . "\n", FILE_APPEND);
                    }
                } else {
                    $hata_sayisi++;
                    file_put_contents($log_file, "Ödül ekleme hatası - Kullanıcı: $kullanici_adi, Hata: " . $vt->error . "\n", FILE_APPEND);
                }
            } else {
                file_put_contents($log_file, "Ödül zaten eklenmiş - Kullanıcı: $kullanici_adi, Tip: {$odul['tip']}, Miktar: {$odul['miktar']}\n", FILE_APPEND);
            }
        }
        
        // Sıralamayı güncelle
        $sira++;
    }
    
    // Sonuç mesajı
    if ($dagitilan_odul_sayisi > 0) {
        $mesaj = '<div class="alert alert-success">Ödül dağıtımı tamamlandı! Toplam ' . $dagitilan_odul_sayisi . ' ödül dağıtıldı.</div>';
    } elseif ($hata_sayisi > 0) {
        $mesaj = '<div class="alert alert-danger">Ödül dağıtımı sırasında hatalar oluştu. Lütfen log dosyasını kontrol edin.</div>';
    } else {
        $mesaj = '<div class="alert alert-info">Dağıtılacak yeni ödül bulunamadı. Tüm ödüller daha önce dağıtılmış olabilir.</div>';
    }
    
    file_put_contents($log_file, "Ödül dağıtım tamamlandı - Dağıtılan: $dagitilan_odul_sayisi, Hata: $hata_sayisi - " . date('Y-m-d H:i:s') . "\n", FILE_APPEND);
}

// Header ve footer
require_once 'includes/header.php';
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Otomatik Ödül Dağıtımı</h1>
        <a href="oduller.php" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Ödüllere Dön
        </a>
    </div>
    
    <?php echo $mesaj; ?>
    
    <div class="card">
        <div class="card-body">
            <h5 class="card-title">Ödül Dağıtım Bilgileri</h5>
            <p>Bu sayfa, turnuva bitiminde otomatik olarak ödülleri hesaplar ve dağıtır.</p>
            
            <h6>Ödül Kriterleri:</h6>
            <ul>
                <li>İlk 5 sıradaki kullanıcılara sıralama ödülleri (<?php foreach (ustOdulleriAl() as $odul) { echo $odul['sira'] . '. sıra: ' . number_format($odul['odul'], 0, ',', '.') . ' TL, '; } ?>)</li>
                <li>En az <?php echo minDavetSayisiAl(); ?> davet yapanlara <?php echo number_format(freebetMiktariAl(), 0, ',', '.'); ?> TL Freebet</li>
                <li>Minimum davet sayısının üzerindeki her davet için <?php echo number_format(ekstraOdulMiktariAl(), 0, ',', '.'); ?> TL nakit ödül</li>
            </ul>
            
            <div class="alert alert-warning">
                <strong>Not:</strong> Bu işlem, daha önce dağıtılmamış ödülleri hesaplar ve dağıtır. Aynı ödül birden fazla kez dağıtılmaz.
            </div>
            
            <a href="odul_dagitim.php" class="btn btn-primary">
                <i class="fas fa-sync"></i> Ödül Dağıtımını Tekrar Çalıştır
            </a>
            
            <a href="odul_dagitim_log.txt" target="_blank" class="btn btn-info ml-2">
                <i class="fas fa-file-alt"></i> Log Dosyasını Görüntüle
            </a>
        </div>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
