<?php
require_once 'includes/auth.php';
require_once '../bot/config.php';

$baslik = "Etkinlik Kuralları";
$mesaj = "";

// Kurallar için ayarlar tablosunda bir alan oluşturalım
$kurallar_sorgu = $vt->query("SELECT * FROM ayarlar WHERE anahtar = 'TURNUVA_KURALLARI'");
if ($kurallar_sorgu->num_rows === 0) {
    // Kurallar ayarı yoksa oluştur
    $varsayilan_kurallar = "📜 *BETPLAY TELEGRAM DAVET TURNUVASI KURALLARI*\n\n";
    $varsayilan_kurallar .= "*Turnuva Tarihleri*\n";
    $varsayilan_kurallar .= "Turnuva, 23 Nisan 2025 saat 00:01 itibarıyla başlayacak ve 03 Mayıs 2025 saat 23:59'da sona erecektir.\n\n";
    $varsayilan_kurallar .= "*📌 Turnuva Katılım Koşulları*\n";
    $varsayilan_kurallar .= "1. Turnuvaya katılmak için Betplay hesabınız olmalıdır.\n";
    $varsayilan_kurallar .= "2. Telegram hesabınızda telefon numaranız doğrulanmış olmalıdır.\n";
    $varsayilan_kurallar .= "3. Resmi Betplay Telegram kanallarına abone olmalısınız.\n\n";
    $varsayilan_kurallar .= "*🎁 Ödül Dağıtım Kuralları*\n";
    $varsayilan_kurallar .= "En çok arkadaşını davet eden ilk 5 kişi aşağıdaki nakit ödülleri kazanacaktır:\n";
    $varsayilan_kurallar .= "1. 150.000 TL\n";
    $varsayilan_kurallar .= "2. 75.000 TL\n";
    $varsayilan_kurallar .= "3. 50.000 TL\n";
    $varsayilan_kurallar .= "4. 25.000 TL\n";
    $varsayilan_kurallar .= "5. 10.000 TL\n\n";
    $varsayilan_kurallar .= "*Ekstra Ödüllerle Herkes Kazanıyor!*\n";
    $varsayilan_kurallar .= "- En az 5 arkadaşını davet eden herkese: 500 TL FREEBET\n";
    $varsayilan_kurallar .= "- 5'in üzerindeki her davet için: 100 TL NAKİT ÖDÜL\n";
    
    $vt->query("INSERT INTO ayarlar (anahtar, deger, aciklama) VALUES ('TURNUVA_KURALLARI', '" . $vt->real_escape_string($varsayilan_kurallar) . "', 'Turnuva kuralları metni')");
    $kurallar = $varsayilan_kurallar;
} else {
    $kurallar_veri = $kurallar_sorgu->fetch_assoc();
    $kurallar = $kurallar_veri['deger'];
}

// Kuralları güncelle
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['kurallar_guncelle'])) {
    $yeni_kurallar = $_POST['kurallar'];
    
    $sorgu = $vt->prepare("UPDATE ayarlar SET deger = ? WHERE anahtar = 'TURNUVA_KURALLARI'");
    $sorgu->bind_param("s", $yeni_kurallar);
    
    if ($sorgu->execute()) {
        $mesaj = '<div class="alert alert-success">Etkinlik kuralları başarıyla güncellendi.</div>';
        $kurallar = $yeni_kurallar;
    } else {
        $mesaj = '<div class="alert alert-danger">Etkinlik kuralları güncellenirken bir hata oluştu: ' . $vt->error . '</div>';
    }
}

include 'includes/header.php';
?>

<div class="container-fluid px-4">
    <h1 class="mt-4"><?php echo $baslik; ?></h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
        <li class="breadcrumb-item active"><?php echo $baslik; ?></li>
    </ol>
    
    <?php echo $mesaj; ?>
    
    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-scroll me-1"></i>
            Etkinlik Kurallarını Düzenle
        </div>
        <div class="card-body">
            <form method="post" action="">
                <div class="mb-3">
                    <label for="kurallar" class="form-label">Kurallar Metni</label>
                    <textarea class="form-control" id="kurallar" name="kurallar" rows="20"><?php echo htmlspecialchars($kurallar); ?></textarea>
                    <div class="form-text">
                        <strong>Markdown formatını kullanabilirsiniz:</strong><br>
                        *italik* için yıldız, **kalın** için çift yıldız, [link](https://example.com) için köşeli ve normal parantez kullanın.<br>
                        Satır başı için \n kullanın.
                    </div>
                </div>
                
                <div class="mb-3">
                    <h5>Önizleme</h5>
                    <div class="card">
                        <div class="card-body" id="kurallarOnizleme">
                            <!-- JavaScript ile önizleme burada gösterilecek -->
                        </div>
                    </div>
                </div>
                
                <button type="submit" name="kurallar_guncelle" class="btn btn-primary">Kuralları Güncelle</button>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const kurallarTextarea = document.getElementById('kurallar');
    const kurallarOnizleme = document.getElementById('kurallarOnizleme');
    
    // Markdown'ı HTML'e dönüştür ve önizleme olarak göster
    function updatePreview() {
        const markdown = kurallarTextarea.value;
        // Satır sonlarını <br> etiketine dönüştür
        const htmlWithLineBreaks = markdown.replace(/\n/g, '<br>');
        // Markdown'ı HTML'e dönüştür
        kurallarOnizleme.innerHTML = marked.parse(htmlWithLineBreaks);
    }
    
    // Sayfa yüklendiğinde önizlemeyi güncelle
    updatePreview();
    
    // Textarea değiştiğinde önizlemeyi güncelle
    kurallarTextarea.addEventListener('input', updatePreview);
});
</script>

<?php include 'includes/footer.php'; ?>
