<?php
/**
 * Betplay Davet Turnuvası - Yönetim Paneli
 * Kullanıcılar Sayfası
 */
require_once '../bot/config.php';
require_once 'includes/header.php';

// Sayfalama için değişkenler
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$limit = 20;
$offset = ($sayfa - 1) * $limit;

// Arama filtresi
$arama = isset($_GET['arama']) ? $vt->real_escape_string($_GET['arama']) : '';
$arama_filtresi = '';
if (!empty($arama)) {
    $arama_filtresi = " WHERE 
        telegram_id LIKE '%$arama%' OR 
        kullanici_adi LIKE '%$arama%' OR 
        ad LIKE '%$arama%' OR 
        soyad LIKE '%$arama%' OR 
        telefon LIKE '%$arama%'";
}

// Toplam kullanıcı sayısını al
$toplam_sorgu = "SELECT COUNT(*) as toplam FROM kullanicilar" . $arama_filtresi;
$toplam_sonuc = $vt->query($toplam_sorgu);
$toplam_satir = $toplam_sonuc->fetch_assoc()['toplam'];
$toplam_sayfa = ceil($toplam_satir / $limit);

// Kullanıcıları al
$kullanicilar_sorgu = "
    SELECT 
        k.*,
        (SELECT COUNT(*) FROM davetler WHERE davet_eden_id = k.id AND aktif = TRUE) as davet_sayisi
    FROM 
        kullanicilar k
    $arama_filtresi
    ORDER BY 
        k.kayit_tarihi DESC
    LIMIT $offset, $limit
";
$kullanicilar = $vt->query($kullanicilar_sorgu);

// Kullanıcı silme işlemi
if (isset($_POST['sil']) && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $vt->query("DELETE FROM kullanicilar WHERE id = $id");
    echo "<script>window.location.href = 'kullanicilar.php';</script>";
    exit;
}

// Kullanıcı durumunu değiştirme
if (isset($_POST['durum_degistir']) && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $yeni_durum = (int)$_POST['yeni_durum'];
    $vt->query("UPDATE kullanicilar SET aktif = $yeni_durum WHERE id = $id");
    echo "<script>window.location.href = 'kullanicilar.php';</script>";
    exit;
}
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Kullanıcılar</h1>
        <div class="d-flex">
            <form class="form-inline mr-2">
                <div class="input-group">
                    <input type="text" class="form-control" placeholder="Ara..." name="arama" value="<?php echo htmlspecialchars($arama); ?>">
                    <div class="input-group-append">
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Telegram ID</th>
                            <th>Kullanıcı Adı</th>
                            <th>Ad Soyad</th>
                            <th>Telefon</th>
                            <th>Davet Sayısı</th>
                            <th>Kayıt Tarihi</th>
                            <th>Durum</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($kullanici = $kullanicilar->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $kullanici['id']; ?></td>
                                <td><?php echo $kullanici['telegram_id']; ?></td>
                                <td>
                                    <?php if (!empty($kullanici['kullanici_adi'])): ?>
                                        @<?php echo htmlspecialchars($kullanici['kullanici_adi']); ?>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td><?php echo htmlspecialchars($kullanici['ad'] . ' ' . $kullanici['soyad']); ?></td>
                                <td><?php echo $kullanici['telefon'] ?? '-'; ?></td>
                                <td><?php echo $kullanici['davet_sayisi']; ?></td>
                                <td><?php echo date('d.m.Y H:i', strtotime($kullanici['kayit_tarihi'])); ?></td>
                                <td>
                                    <?php if ($kullanici['aktif']): ?>
                                        <span class="badge badge-success">Aktif</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger">Pasif</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="kullanici_detay.php?id=<?php echo $kullanici['id']; ?>" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <form method="post" class="d-inline" onsubmit="return confirm('Kullanıcı durumunu değiştirmek istediğinize emin misiniz?');">
                                            <input type="hidden" name="id" value="<?php echo $kullanici['id']; ?>">
                                            <input type="hidden" name="yeni_durum" value="<?php echo $kullanici['aktif'] ? 0 : 1; ?>">
                                            <button type="submit" name="durum_degistir" class="btn btn-sm btn-<?php echo $kullanici['aktif'] ? 'warning' : 'success'; ?>">
                                                <i class="fas fa-<?php echo $kullanici['aktif'] ? 'ban' : 'check'; ?>"></i>
                                            </button>
                                        </form>
                                        <form method="post" class="d-inline" onsubmit="return confirm('Bu kullanıcıyı silmek istediğinize emin misiniz?');">
                                            <input type="hidden" name="id" value="<?php echo $kullanici['id']; ?>">
                                            <button type="submit" name="sil" class="btn btn-sm btn-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if ($toplam_sayfa > 1): ?>
                <nav>
                    <ul class="pagination justify-content-center">
                        <?php if ($sayfa > 1): ?>
                            <li class="page-item">
                                <a class="page-link" href="?sayfa=<?php echo $sayfa - 1; ?><?php echo !empty($arama) ? '&arama=' . urlencode($arama) : ''; ?>">
                                    <i class="fas fa-chevron-left"></i>
                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <?php for ($i = max(1, $sayfa - 2); $i <= min($toplam_sayfa, $sayfa + 2); $i++): ?>
                            <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                                <a class="page-link" href="?sayfa=<?php echo $i; ?><?php echo !empty($arama) ? '&arama=' . urlencode($arama) : ''; ?>">
                                    <?php echo $i; ?>
                                </a>
                            </li>
                        <?php endfor; ?>
                        
                        <?php if ($sayfa < $toplam_sayfa): ?>
                            <li class="page-item">
                                <a class="page-link" href="?sayfa=<?php echo $sayfa + 1; ?><?php echo !empty($arama) ? '&arama=' . urlencode($arama) : ''; ?>">
                                    <i class="fas fa-chevron-right"></i>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
