<?php
/**
 * Betplay Davet Turnuvası - Yönetim Paneli
 * Kullanıcı Detay Sayfası
 */
require_once '../bot/config.php';

// Hata ayıklama için
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Hata ayıklama için log dosyası
$log_file = 'kullanici_detay_log.txt';
file_put_contents($log_file, "Sayfa yükleniyor - " . date('Y-m-d H:i:s') . "\n", FILE_APPEND);

require_once 'includes/header.php';

// Kullanıcı ID'sini al
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
file_put_contents($log_file, "ID: $id\n", FILE_APPEND);

if ($id <= 0) {
    file_put_contents($log_file, "Geçersiz ID\n", FILE_APPEND);
    echo "<script>window.location.href = 'kullanicilar.php';</script>";
    exit;
}

// Kullanıcı bilgilerini al
$kullanici_sorgu = "
    SELECT 
        k.*,
        (SELECT COUNT(*) FROM davetler WHERE davet_eden_id = k.id AND aktif = TRUE) as davet_sayisi
    FROM 
        kullanicilar k
    WHERE 
        k.id = $id
";
file_put_contents($log_file, "Sorgu: $kullanici_sorgu\n", FILE_APPEND);

$kullanici_sonuc = $vt->query($kullanici_sorgu);
file_put_contents($log_file, "Sorgu sonucu satır sayısı: " . ($kullanici_sonuc ? $kullanici_sonuc->num_rows : 'Sorgu hatası') . "\n", FILE_APPEND);

if (!$kullanici_sonuc) {
    file_put_contents($log_file, "Veritabanı hatası: " . $vt->error . "\n", FILE_APPEND);
    echo '<div class="alert alert-danger">Veritabanı hatası: ' . $vt->error . '</div>';
}

if ($kullanici_sonuc && $kullanici_sonuc->num_rows == 0) {
    file_put_contents($log_file, "Kullanıcı bulunamadı\n", FILE_APPEND);
    echo "<script>window.location.href = 'kullanicilar.php';</script>";
    exit;
}

$kullanici = $kullanici_sonuc->fetch_assoc();
file_put_contents($log_file, "Kullanıcı bilgileri alındı\n", FILE_APPEND);

// Kullanıcının davet ettiği kişileri al
$davetler_sorgu = "
    SELECT 
        d.*,
        k.telegram_id,
        k.kullanici_adi,
        k.ad,
        k.soyad,
        k.kayit_tarihi
    FROM 
        davetler d
    JOIN 
        kullanicilar k ON d.davet_edilen_id = k.id
    WHERE 
        d.davet_eden_id = $id
    ORDER BY 
        d.davet_tarihi DESC
";
$davetler = $vt->query($davetler_sorgu);
file_put_contents($log_file, "Davet edilen kişiler sorgusu: " . ($davetler ? $davetler->num_rows : 'Sorgu hatası') . "\n", FILE_APPEND);

if (!$davetler) {
    file_put_contents($log_file, "Veritabanı hatası: " . $vt->error . "\n", FILE_APPEND);
    echo '<div class="alert alert-danger">Veritabanı hatası: ' . $vt->error . '</div>';
}

// Kullanıcının ödüllerini al
$oduller_sorgu = "
    SELECT * FROM oduller
    WHERE kullanici_id = $id
    ORDER BY olusturma_tarihi DESC
";
$oduller = $vt->query($oduller_sorgu);
file_put_contents($log_file, "Ödüller sorgusu: " . ($oduller ? $oduller->num_rows : 'Sorgu hatası') . "\n", FILE_APPEND);

if (!$oduller) {
    file_put_contents($log_file, "Veritabanı hatası: " . $vt->error . "\n", FILE_APPEND);
    echo '<div class="alert alert-danger">Veritabanı hatası: ' . $vt->error . '</div>';
}

// Kullanıcı güncelleme işlemi
$mesaj = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['guncelle'])) {
    $kullanici_adi = $vt->real_escape_string($_POST['kullanici_adi']);
    $ad = $vt->real_escape_string($_POST['ad']);
    $soyad = $vt->real_escape_string($_POST['soyad']);
    $telefon = $vt->real_escape_string($_POST['telefon']);
    $aktif = isset($_POST['aktif']) ? 1 : 0;
    
    $vt->query("UPDATE kullanicilar SET kullanici_adi = '$kullanici_adi', ad = '$ad', soyad = '$soyad', telefon = '$telefon', aktif = $aktif WHERE id = $id");
    
    if ($vt->affected_rows >= 0) {
        $mesaj = '<div class="alert alert-success">Kullanıcı bilgileri başarıyla güncellendi!</div>';
        
        // Kullanıcı bilgilerini yeniden yükle
        $kullanici_sonuc = $vt->query($kullanici_sorgu);
        $kullanici = $kullanici_sonuc->fetch_assoc();
    } else {
        $mesaj = '<div class="alert alert-danger">Kullanıcı bilgileri güncellenirken bir hata oluştu!</div>';
    }
}

// Ödül ekleme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['odul_ekle'])) {
    $odul_tipi = $vt->real_escape_string($_POST['odul_tipi']);
    $miktar = (float)$_POST['miktar'];
    $durum = $vt->real_escape_string($_POST['durum']);
    
    $vt->query("INSERT INTO oduller (kullanici_id, odul_tipi, miktar, durum, olusturma_tarihi) VALUES ($id, '$odul_tipi', $miktar, '$durum', NOW())");
    
    if ($vt->affected_rows > 0) {
        $mesaj = '<div class="alert alert-success">Ödül başarıyla eklendi!</div>';
        
        // Ödülleri yeniden yükle
        $oduller = $vt->query($oduller_sorgu);
    } else {
        $mesaj = '<div class="alert alert-danger">Ödül eklenirken bir hata oluştu!</div>';
    }
}

// Ödül silme
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['odul_sil'])) {
    $odul_id = (int)$_POST['odul_id'];
    
    $vt->query("DELETE FROM oduller WHERE id = $odul_id AND kullanici_id = $id");
    
    if ($vt->affected_rows > 0) {
        $mesaj = '<div class="alert alert-success">Ödül başarıyla silindi!</div>';
        
        // Ödülleri yeniden yükle
        $oduller = $vt->query($oduller_sorgu);
    } else {
        $mesaj = '<div class="alert alert-danger">Ödül silinirken bir hata oluştu!</div>';
    }
}

// Potansiyel ödülleri hesapla
$davet_sayisi = $kullanici['davet_sayisi'];

// Fonksiyonları kullan (config.php'den)
$min_davet = minDavetSayisiAl();
$freebet = ($davet_sayisi >= $min_davet) ? freebetMiktariAl() : 0;
$ekstra_nakit = ($davet_sayisi > $min_davet) ? ($davet_sayisi - $min_davet) * ekstraOdulMiktariAl() : 0;

// Kullanıcının sıralamasını al
$siralama_sorgu = "
    SELECT kullanici_sira
    FROM (
        SELECT 
            k.id,
            COUNT(d.id) as davet_sayisi,
            RANK() OVER (ORDER BY COUNT(d.id) DESC, MIN(d.davet_tarihi) ASC) as kullanici_sira
        FROM 
            kullanicilar k
        LEFT JOIN 
            davetler d ON k.id = d.davet_eden_id AND d.aktif = TRUE
        GROUP BY 
            k.id
    ) as siralanmis
    WHERE id = $id
";
$siralama_result = $vt->query($siralama_sorgu);
$siralama_row = $siralama_result->fetch_assoc();
$kullanici_sira = $siralama_row ? $siralama_row['kullanici_sira'] : 'N/A';

// Üst ödülleri al (config.php'den)
$ust_oduller_array = ustOdulleriAl();
$siralama_odulu = 0;

// Sıralama ödülünü hesapla
if (is_numeric($kullanici_sira) && $kullanici_sira <= 5 && $davet_sayisi > 0) {
    foreach ($ust_oduller_array as $odul) {
        if ($odul['sira'] == $kullanici_sira) {
            $siralama_odulu = $odul['odul'];
            break;
        }
    }
}

$toplam_potansiyel = $siralama_odulu + $freebet + $ekstra_nakit;
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Kullanıcı Detayları</h1>
        <a href="kullanicilar.php" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Kullanıcılara Dön
        </a>
    </div>
    
    <?php echo $mesaj; ?>
    
    <div class="row">
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Kullanıcı Bilgileri</h5>
                </div>
                <div class="card-body">
                    <form method="post">
                        <div class="form-group">
                            <label for="telegram_id">Telegram ID</label>
                            <input type="text" class="form-control" id="telegram_id" value="<?php echo $kullanici['telegram_id']; ?>" readonly>
                        </div>
                        <div class="form-group">
                            <label for="kullanici_adi">Kullanıcı Adı</label>
                            <input type="text" class="form-control" id="kullanici_adi" name="kullanici_adi" value="<?php echo htmlspecialchars($kullanici['kullanici_adi']); ?>">
                        </div>
                        <div class="form-group">
                            <label for="ad">Ad</label>
                            <input type="text" class="form-control" id="ad" name="ad" value="<?php echo htmlspecialchars($kullanici['ad']); ?>">
                        </div>
                        <div class="form-group">
                            <label for="soyad">Soyad</label>
                            <input type="text" class="form-control" id="soyad" name="soyad" value="<?php echo htmlspecialchars($kullanici['soyad']); ?>">
                        </div>
                        <div class="form-group">
                            <label for="telefon">Telefon</label>
                            <input type="text" class="form-control" id="telefon" name="telefon" value="<?php echo htmlspecialchars($kullanici['telefon'] ?? ''); ?>">
                        </div>
                        <div class="form-group">
                            <label for="davet_linki">Davet Linki</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="davet_linki" value="<?php echo htmlspecialchars($kullanici['davet_linki']); ?>" readonly>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" onclick="copyToClipboard('davet_linki')">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="kayit_tarihi">Kayıt Tarihi</label>
                            <input type="text" class="form-control" id="kayit_tarihi" value="<?php echo date('d.m.Y H:i', strtotime($kullanici['kayit_tarihi'])); ?>" readonly>
                        </div>
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="aktif" name="aktif" <?php echo $kullanici['aktif'] ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="aktif">Aktif</label>
                            </div>
                        </div>
                        <button type="submit" name="guncelle" class="btn btn-primary">Güncelle</button>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">Davet İstatistikleri</h5>
                </div>
                <div class="card-body">
                    <p><strong>Toplam Davet Sayısı:</strong> <?php echo $davet_sayisi; ?></p>
                    <p><strong>Sıralama:</strong> <?php echo $kullanici_sira; ?></p>
                    
                    <h5 class="mt-4">Potansiyel Ödüller</h5>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <?php if (is_numeric($kullanici_sira) && $kullanici_sira <= 5 && $davet_sayisi > 0): ?>
                                    <tr>
                                        <td>Sıralama Ödülü (<?php echo $kullanici_sira; ?>. sıra)</td>
                                        <td class="text-right"><?php echo number_format($siralama_odulu, 2, ',', '.'); ?> TL</td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($freebet > 0): ?>
                                    <tr>
                                        <td>Freebet</td>
                                        <td class="text-right"><?php echo number_format($freebet, 2, ',', '.'); ?> TL</td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($ekstra_nakit > 0): ?>
                                    <tr>
                                        <td>Ekstra Nakit (<?php echo $davet_sayisi - $min_davet; ?> x <?php echo ekstraOdulMiktariAl(); ?> TL)</td>
                                        <td class="text-right"><?php echo number_format($ekstra_nakit, 2, ',', '.'); ?> TL</td>
                                    </tr>
                                <?php endif; ?>
                                <tr class="table-primary">
                                    <th>Toplam Potansiyel</th>
                                    <th class="text-right"><?php echo number_format($toplam_potansiyel, 2, ',', '.'); ?> TL</th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <button type="button" class="btn btn-success mt-3" onclick="acModal()">
                        <i class="fas fa-plus"></i> Ödül Ekle
                    </button>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">Ödüller</h5>
                </div>
                <div class="card-body">
                    <?php if ($oduller->num_rows > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Tip</th>
                                        <th>Miktar</th>
                                        <th>Durum</th>
                                        <th>Tarih</th>
                                        <th>İşlem</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while ($odul = $oduller->fetch_assoc()): ?>
                                        <tr>
                                            <td>
                                                <?php if ($odul['odul_tipi'] == 'NAKIT'): ?>
                                                    <span class="badge badge-success">NAKİT</span>
                                                <?php else: ?>
                                                    <span class="badge badge-info">FREEBET</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo number_format($odul['miktar'], 2, ',', '.'); ?> TL</td>
                                            <td>
                                                <?php if ($odul['durum'] == 'BEKLEMEDE'): ?>
                                                    <span class="badge badge-warning">BEKLEMEDE</span>
                                                <?php elseif ($odul['durum'] == 'DAGITILDI'): ?>
                                                    <span class="badge badge-success">DAĞITILDI</span>
                                                <?php else: ?>
                                                    <span class="badge badge-info">ALINDI</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo date('d.m.Y H:i', strtotime($odul['olusturma_tarihi'])); ?></td>
                                            <td>
                                                <form method="post" onsubmit="return confirm('Bu ödülü silmek istediğinize emin misiniz?');">
                                                    <input type="hidden" name="odul_id" value="<?php echo $odul['id']; ?>">
                                                    <button type="submit" name="odul_sil" class="btn btn-sm btn-danger">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">Henüz ödül bulunmuyor.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    <h5 class="mb-0">Davet Ettiği Kullanıcılar</h5>
                </div>
                <div class="card-body">
                    <?php if ($davetler->num_rows > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Kullanıcı</th>
                                        <th>Davet Tarihi</th>
                                        <th>Durum</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while ($davet = $davetler->fetch_assoc()): ?>
                                        <tr>
                                            <td>
                                                <?php if (!empty($davet['kullanici_adi'])): ?>
                                                    @<?php echo htmlspecialchars($davet['kullanici_adi']); ?>
                                                <?php else: ?>
                                                    <?php echo htmlspecialchars($davet['ad'] . ' ' . $davet['soyad']); ?>
                                                <?php endif; ?>
                                                <br>
                                                <small class="text-muted">ID: <?php echo $davet['telegram_id']; ?></small>
                                            </td>
                                            <td><?php echo date('d.m.Y H:i', strtotime($davet['davet_tarihi'])); ?></td>
                                            <td>
                                                <?php if ($davet['aktif']): ?>
                                                    <span class="badge badge-success">Aktif</span>
                                                <?php else: ?>
                                                    <span class="badge badge-danger">Pasif</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">Henüz davet ettiği kullanıcı bulunmuyor.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Ödül Ekle Modal -->
<div class="modal" id="odulEkleModal" tabindex="-1" role="dialog" aria-labelledby="odulEkleModalLabel" aria-hidden="true" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.5); display: none; z-index: 9999;">
    <div class="modal-dialog" role="document" style="position: relative; margin: 10% auto; width: 500px; background-color: #fff; border-radius: 5px; z-index: 10000;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="odulEkleModalLabel">Ödül Ekle</h5>
                <button type="button" class="close" onclick="kapatModal()" aria-label="Kapat">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="odul_tipi">Ödül Tipi</label>
                        <select class="form-control" id="odul_tipi" name="odul_tipi" required>
                            <option value="NAKIT">NAKİT</option>
                            <option value="FREEBET">FREEBET</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="miktar">Miktar (TL)</label>
                        <input type="number" class="form-control" id="miktar" name="miktar" step="0.01" required>
                    </div>
                    <div class="form-group">
                        <label for="durum">Durum</label>
                        <select class="form-control" id="durum" name="durum" required>
                            <option value="BEKLEMEDE">BEKLEMEDE</option>
                            <option value="DAGITILDI">DAĞITILDI</option>
                            <option value="ALINDI">ALINDI</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="kapatModal()">İptal</button>
                    <button type="submit" name="odul_ekle" class="btn btn-primary">Ekle</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function copyToClipboard(elementId) {
    var copyText = document.getElementById(elementId);
    copyText.select();
    document.execCommand("copy");
    alert("Kopyalandı: " + copyText.value);
}

// Özel modal fonksiyonları
function acModal() {
    document.getElementById('odulEkleModal').style.display = 'block';
    document.body.style.overflow = 'hidden'; // Sayfanın kaydırılmasını engelle
}

function kapatModal() {
    document.getElementById('odulEkleModal').style.display = 'none';
    document.body.style.overflow = 'auto'; // Sayfanın kaydırılmasını tekrar etkinleştir
}

// Ödül Ekle butonuna tıklandığında modalı aç
document.addEventListener('DOMContentLoaded', function() {
    var odulEkleButtons = document.querySelectorAll('.odul-ekle-btn');
    odulEkleButtons.forEach(function(button) {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            acModal();
        });
    });
    
    // Modal dışına tıklandığında kapat
    window.addEventListener('click', function(e) {
        var modal = document.getElementById('odulEkleModal');
        if (e.target === modal) {
            kapatModal();
        }
    });
});
</script>

<?php require_once 'includes/footer.php'; ?>
