<?php
require_once 'includes/auth.php';
require_once '../bot/config.php';

$baslik = "Kanal Yönetimi";
$mesaj = "";

// Kanal ekle
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['kanal_ekle'])) {
    $kanal_kullanici_adi = $_POST['kanal_kullanici_adi'];
    $kanal_adi = $_POST['kanal_adi'];
    $zorunlu = isset($_POST['zorunlu']) ? 1 : 0;
    
    // @ işareti ile başlamıyorsa ekle
    if (strpos($kanal_kullanici_adi, '@') !== 0) {
        $kanal_kullanici_adi = '@' . $kanal_kullanici_adi;
    }
    
    $sorgu = $vt->prepare("INSERT INTO kanallar (kanal_kullanici_adi, kanal_adi, zorunlu) VALUES (?, ?, ?)");
    $sorgu->bind_param("ssi", $kanal_kullanici_adi, $kanal_adi, $zorunlu);
    
    if ($sorgu->execute()) {
        $mesaj = '<div class="alert alert-success">Kanal başarıyla eklendi.</div>';
    } else {
        $mesaj = '<div class="alert alert-danger">Kanal eklenirken bir hata oluştu: ' . $vt->error . '</div>';
    }
}

// Kanal sil
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['kanal_sil'])) {
    $kanal_id = $_POST['kanal_id'];
    
    $sorgu = $vt->prepare("DELETE FROM kanallar WHERE id = ?");
    $sorgu->bind_param("i", $kanal_id);
    
    if ($sorgu->execute()) {
        $mesaj = '<div class="alert alert-success">Kanal başarıyla silindi.</div>';
    } else {
        $mesaj = '<div class="alert alert-danger">Kanal silinirken bir hata oluştu: ' . $vt->error . '</div>';
    }
}

// Kanal durumunu değiştir
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['kanal_durum_degistir'])) {
    $kanal_id = $_POST['kanal_id'];
    $yeni_durum = $_POST['yeni_durum'];
    
    $sorgu = $vt->prepare("UPDATE kanallar SET zorunlu = ? WHERE id = ?");
    $sorgu->bind_param("ii", $yeni_durum, $kanal_id);
    
    if ($sorgu->execute()) {
        $mesaj = '<div class="alert alert-success">Kanal durumu başarıyla güncellendi.</div>';
    } else {
        $mesaj = '<div class="alert alert-danger">Kanal durumu güncellenirken bir hata oluştu: ' . $vt->error . '</div>';
    }
}

// Kanalları getir
$kanallar_sorgu = $vt->query("SELECT * FROM kanallar ORDER BY id DESC");
$kanallar = [];

while ($kanal = $kanallar_sorgu->fetch_assoc()) {
    $kanallar[] = $kanal;
}

include 'includes/header.php';
?>

<div class="container-fluid px-4">
    <h1 class="mt-4"><?php echo $baslik; ?></h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
        <li class="breadcrumb-item active"><?php echo $baslik; ?></li>
    </ol>
    
    <?php echo $mesaj; ?>
    
    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-bullhorn me-1"></i>
            Kanal Ekle
        </div>
        <div class="card-body">
            <form method="post" action="">
                <div class="row">
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label for="kanal_kullanici_adi" class="form-label">Kanal Kullanıcı Adı</label>
                            <input type="text" class="form-control" id="kanal_kullanici_adi" name="kanal_kullanici_adi" placeholder="@kanal_adi" required>
                            <div class="form-text">Kanal kullanıcı adı @ ile başlamalıdır.</div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label for="kanal_adi" class="form-label">Kanal Adı</label>
                            <input type="text" class="form-control" id="kanal_adi" name="kanal_adi" placeholder="Kanal Adı" required>
                            <div class="form-text">Kanalın görünen adı.</div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label d-block">&nbsp;</label>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="zorunlu" name="zorunlu" checked>
                                <label class="form-check-label" for="zorunlu">
                                    Zorunlu Kanal
                                </label>
                            </div>
                            <div class="form-text">Kullanıcıların bu kanala katılması zorunlu mu?</div>
                        </div>
                    </div>
                </div>
                <button type="submit" name="kanal_ekle" class="btn btn-primary">Kanal Ekle</button>
            </form>
        </div>
    </div>
    
    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-table me-1"></i>
            Kanallar
        </div>
        <div class="card-body">
            <table id="kanallarTable" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Kanal Kullanıcı Adı</th>
                        <th>Kanal Adı</th>
                        <th>Durum</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($kanallar as $kanal): ?>
                    <tr>
                        <td><?php echo $kanal['id']; ?></td>
                        <td><a href="https://t.me/<?php echo ltrim($kanal['kanal_kullanici_adi'], '@'); ?>" target="_blank"><?php echo $kanal['kanal_kullanici_adi']; ?></a></td>
                        <td><?php echo $kanal['kanal_adi']; ?></td>
                        <td>
                            <?php if ($kanal['zorunlu']): ?>
                                <span class="badge bg-success">Zorunlu</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">İsteğe Bağlı</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <?php if ($kanal['zorunlu']): ?>
                                    <form method="post" class="d-inline">
                                        <input type="hidden" name="kanal_id" value="<?php echo $kanal['id']; ?>">
                                        <input type="hidden" name="yeni_durum" value="0">
                                        <button type="submit" name="kanal_durum_degistir" class="btn btn-sm btn-warning">İsteğe Bağlı Yap</button>
                                    </form>
                                <?php else: ?>
                                    <form method="post" class="d-inline">
                                        <input type="hidden" name="kanal_id" value="<?php echo $kanal['id']; ?>">
                                        <input type="hidden" name="yeni_durum" value="1">
                                        <button type="submit" name="kanal_durum_degistir" class="btn btn-sm btn-success">Zorunlu Yap</button>
                                    </form>
                                <?php endif; ?>
                                
                                <form method="post" class="d-inline" onsubmit="return confirm('Bu kanalı silmek istediğinize emin misiniz?');">
                                    <input type="hidden" name="kanal_id" value="<?php echo $kanal['id']; ?>">
                                    <button type="submit" name="kanal_sil" class="btn btn-sm btn-danger">Sil</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // DataTable başlat
    new DataTable('#kanallarTable', {
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.4/i18n/tr.json',
        }
    });
});
</script>

<?php include 'includes/footer.php'; ?>
