<?php
/**
 * Betplay Davet Turnuvası - Yönetim Paneli
 * İstatistikler Sayfası
 */
require_once '../bot/config.php';
require_once 'includes/header.php';

// Tarih filtreleme için varsayılan değerler
$baslangic_tarihi = isset($_GET['baslangic_tarihi']) ? $_GET['baslangic_tarihi'] : date('Y-m-d', strtotime('-30 days'));
$bitis_tarihi = isset($_GET['bitis_tarihi']) ? $_GET['bitis_tarihi'] : date('Y-m-d');

// Minimum davet sayısını veritabanından çek
$min_davet_sayisi = isset($ayarlar['MIN_DAVET_SAYISI']) ? intval($ayarlar['MIN_DAVET_SAYISI']) : 5;

// Sayfalama için varsayılan değerler
$sayfa = isset($_GET['sayfa']) ? intval($_GET['sayfa']) : 1;
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 20;
$offset = ($sayfa - 1) * $limit;

// Sıralama için varsayılan değerler
$siralama = isset($_GET['siralama']) ? $_GET['siralama'] : 'davet_sayisi_desc';
$sira_yon = isset($_GET['sira_yon']) ? $_GET['sira_yon'] : 'DESC';

// Filtreleme için varsayılan değerler
$min_davet = isset($_GET['min_davet']) ? intval($_GET['min_davet']) : 0;
$arama = isset($_GET['arama']) ? $_GET['arama'] : '';

// Query string oluştur (sayfalama için)
$query_string = '';
if (!empty($baslangic_tarihi)) $query_string .= '&baslangic_tarihi=' . $baslangic_tarihi;
if (!empty($bitis_tarihi)) $query_string .= '&bitis_tarihi=' . $bitis_tarihi;
if ($min_davet > 0) $query_string .= '&min_davet=' . $min_davet;
if (!empty($arama)) $query_string .= '&arama=' . urlencode($arama);
if (!empty($siralama)) $query_string .= '&siralama=' . $siralama;
if (!empty($limit) && $limit != 20) $query_string .= '&limit=' . $limit;

?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>İstatistikler</h1>
        <div>
            <a href="index.php" class="btn btn-outline-secondary me-2"><i class="fas fa-arrow-left"></i> Geri</a>
        </div>
    </div>
    
    <!-- İstatistik Özeti Kartları -->
    <div class="row mb-4">
        <?php
        // Hata ayıklama için PHP hata raporlamasını aktifleştir
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);
        
        // Toplam kullanıcı sayısı
        $kullanici_sorgu = "SELECT COUNT(*) as toplam FROM kullanicilar WHERE aktif = 1";
        if (!empty($arama)) {
            $kullanici_sorgu .= " AND (telegram_id LIKE '%$arama%' OR kullanici_adi LIKE '%$arama%' OR telefon LIKE '%$arama%' OR ad LIKE '%$arama%' OR soyad LIKE '%$arama%')";
        }
        $toplam_kullanici = $vt->query($kullanici_sorgu)->fetch_assoc()['toplam'];
        
        // Toplam davet sayısı
        $davet_sorgu = "SELECT COUNT(*) as toplam FROM davetler WHERE aktif = 1";
        if (!empty($baslangic_tarihi) && !empty($bitis_tarihi)) {
            $davet_sorgu .= " AND DATE(davet_tarihi) BETWEEN '$baslangic_tarihi' AND '$bitis_tarihi'";
        }
        $toplam_davet = $vt->query($davet_sorgu)->fetch_assoc()['toplam'];
        
        // Minimum davet sayısını aşan kullanıcı sayısı
        $min_davet_asan_sorgu = "
            SELECT COUNT(*) as toplam 
            FROM (
                SELECT COUNT(*) as davet_sayisi 
                FROM davetler d 
                JOIN kullanicilar k ON d.davet_eden_id = k.id 
                WHERE d.aktif = 1 
        ";
        
        if (!empty($baslangic_tarihi) && !empty($bitis_tarihi)) {
            $min_davet_asan_sorgu .= " AND DATE(d.davet_tarihi) BETWEEN '$baslangic_tarihi' AND '$bitis_tarihi'";
        }
        
        if (!empty($arama)) {
            $min_davet_asan_sorgu .= " AND (k.telegram_id LIKE '%$arama%' OR k.kullanici_adi LIKE '%$arama%' OR k.telefon LIKE '%$arama%' OR k.ad LIKE '%$arama%' OR k.soyad LIKE '%$arama%')";
        }
        
        $min_davet_asan_sorgu .= "
                GROUP BY k.telegram_id 
                HAVING davet_sayisi >= $min_davet_sayisi
            ) as t
        ";
        
        $min_davet_asan = $vt->query($min_davet_asan_sorgu)->fetch_assoc()['toplam'];
        
        // Bugünkü davet sayısı
        $bugun = date('Y-m-d');
        $bugun_davet_sorgu = "SELECT COUNT(*) as toplam FROM davetler WHERE aktif = 1 AND DATE(davet_tarihi) = '$bugun'";
        $bugun_davet = $vt->query($bugun_davet_sorgu)->fetch_assoc()['toplam'];
        
        // Son 7 günde yapılan davet sayısı
        $son_7_gun = date('Y-m-d', strtotime('-7 days'));
        $son_7_gun_davet_sorgu = "SELECT COUNT(*) as toplam FROM davetler WHERE aktif = 1 AND DATE(davet_tarihi) BETWEEN '$son_7_gun' AND '$bugun'";
        $son_7_gun_davet = $vt->query($son_7_gun_davet_sorgu)->fetch_assoc()['toplam'];
        
        // En çok davet yapan kullanıcı
        $en_cok_davet_sorgu = "
            SELECT k.kullanici_adi, COUNT(*) as davet_sayisi 
            FROM davetler d 
            JOIN kullanicilar k ON d.davet_eden_id = k.id 
            WHERE d.aktif = 1 
        ";
        
        if (!empty($baslangic_tarihi) && !empty($bitis_tarihi)) {
            $en_cok_davet_sorgu .= " AND DATE(d.davet_tarihi) BETWEEN '$baslangic_tarihi' AND '$bitis_tarihi'";
        }
        
        $en_cok_davet_sorgu .= "
            GROUP BY d.davet_eden_id 
            ORDER BY davet_sayisi DESC 
            LIMIT 1
        ";
        
        $en_cok_davet_sonuc = $vt->query($en_cok_davet_sorgu);
        $en_cok_davet = $en_cok_davet_sonuc->num_rows > 0 ? $en_cok_davet_sonuc->fetch_assoc() : ['kullanici_adi' => '-', 'davet_sayisi' => 0];
        ?>
        
        <!-- Toplam Kullanıcı Kartı -->
        <div class="col-md-4 mb-3">
            <div class="card bg-primary text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-uppercase">Toplam Kullanıcı</h6>
                            <h2 class="mb-0"><?php echo number_format($toplam_kullanici, 0, ',', '.'); ?></h2>
                        </div>
                        <i class="fas fa-users fa-3x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Toplam Davet Kartı -->
        <div class="col-md-4 mb-3">
            <div class="card bg-success text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-uppercase">Toplam Davet</h6>
                            <h2 class="mb-0"><?php echo number_format($toplam_davet, 0, ',', '.'); ?></h2>
                        </div>
                        <i class="fas fa-link fa-3x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Ödül Kazanan Kartı -->
        <div class="col-md-4 mb-3">
            <div class="card bg-warning text-dark h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-uppercase">Ödül Kazanan</h6>
                            <h2 class="mb-0"><?php echo number_format($min_davet_asan, 0, ',', '.'); ?></h2>
                            <small>Min. <?php echo $min_davet_sayisi; ?> davet yapan kullanıcı</small>
                        </div>
                        <i class="fas fa-trophy fa-3x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Bugünkü Davet Kartı -->
        <div class="col-md-4 mb-3">
            <div class="card bg-info text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-uppercase">Bugünkü Davet</h6>
                            <h2 class="mb-0"><?php echo number_format($bugun_davet, 0, ',', '.'); ?></h2>
                            <small><?php echo date('d.m.Y'); ?> tarihinde</small>
                        </div>
                        <i class="fas fa-calendar-day fa-3x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Son 7 Gün Davet Kartı -->
        <div class="col-md-4 mb-3">
            <div class="card bg-secondary text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-uppercase">Son 7 Gün</h6>
                            <h2 class="mb-0"><?php echo number_format($son_7_gun_davet, 0, ',', '.'); ?></h2>
                            <small>Son 7 günde yapılan davet</small>
                        </div>
                        <i class="fas fa-calendar-week fa-3x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- En Çok Davet Yapan Kartı -->
        <div class="col-md-4 mb-3">
            <div class="card bg-danger text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-uppercase">En Çok Davet</h6>
                            <h2 class="mb-0"><?php echo number_format($en_cok_davet['davet_sayisi'], 0, ',', '.'); ?></h2>
                            <small><?php echo htmlspecialchars($en_cok_davet['kullanici_adi']); ?></small>
                        </div>
                        <i class="fas fa-crown fa-3x opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Filtreleme ve Dışa Aktarma Kartı -->
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="fas fa-filter"></i> Filtreleme ve Dışa Aktarma</h5>
        </div>
        <div class="card-body">
            <form method="get" class="mb-4">
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label for="arama" class="form-label">Kullanıcı Ara</label>
                        <input type="text" class="form-control" id="arama" name="arama" value="<?php echo htmlspecialchars($arama); ?>" placeholder="Telegram ID, Kullanıcı Adı, Telefon...">
                    </div>
                    <div class="col-md-4">
                        <label for="min_davet" class="form-label">Min. Davet Sayısı</label>
                        <div class="input-group">
                            <input type="number" class="form-control" id="min_davet" name="min_davet" value="<?php echo $min_davet; ?>" min="0">
                            <span class="input-group-text" title="Ödül için gereken minimum davet sayısı: <?php echo $min_davet_sayisi; ?>">
                                <i class="fas fa-info-circle"></i> Ödül: <?php echo $min_davet_sayisi; ?>+
                            </span>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label for="siralama" class="form-label">Sıralama</label>
                        <select class="form-control" id="siralama" name="siralama">
                            <option value="davet_sayisi_desc" <?php echo $siralama == 'davet_sayisi_desc' ? 'selected' : ''; ?>>Davet Sayısı (Çok > Az)</option>
                            <option value="davet_sayisi_asc" <?php echo $siralama == 'davet_sayisi_asc' ? 'selected' : ''; ?>>Davet Sayısı (Az > Çok)</option>
                            <option value="kayit_tarihi_desc" <?php echo $siralama == 'kayit_tarihi_desc' ? 'selected' : ''; ?>>Kayıt Tarihi (Yeni > Eski)</option>
                            <option value="kayit_tarihi_asc" <?php echo $siralama == 'kayit_tarihi_asc' ? 'selected' : ''; ?>>Kayıt Tarihi (Eski > Yeni)</option>
                        </select>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label for="baslangic_tarihi" class="form-label">Başlangıç Tarihi</label>
                        <input type="date" class="form-control" id="baslangic_tarihi" name="baslangic_tarihi" value="<?php echo $baslangic_tarihi; ?>">
                    </div>
                    <div class="col-md-4">
                        <label for="bitis_tarihi" class="form-label">Bitiş Tarihi</label>
                        <input type="date" class="form-control" id="bitis_tarihi" name="bitis_tarihi" value="<?php echo $bitis_tarihi; ?>">
                    </div>
                    <div class="col-md-4">
                        <label for="limit" class="form-label">Sayfa Başına Kayıt</label>
                        <select class="form-control" id="limit" name="limit">
                            <option value="10" <?php echo $limit == 10 ? 'selected' : ''; ?>>10</option>
                            <option value="25" <?php echo $limit == 25 ? 'selected' : ''; ?>>25</option>
                            <option value="50" <?php echo $limit == 50 ? 'selected' : ''; ?>>50</option>
                            <option value="100" <?php echo $limit == 100 ? 'selected' : ''; ?>>100</option>
                        </select>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search"></i> Filtrele
                        </button>
                        <a href="istatistikler.php" class="btn btn-secondary ms-2">
                            <i class="fas fa-sync"></i> Sıfırla
                        </a>
                    </div>
                    <div class="col-md-6 text-end">
                        <div class="btn-group" role="group">
                            <a href="disa_aktar.php?format=excel<?php echo $query_string; ?>" class="btn btn-success">
                                <i class="fas fa-file-excel"></i> Excel
                            </a>
                            <a href="disa_aktar.php?format=csv<?php echo $query_string; ?>" class="btn btn-info">
                                <i class="fas fa-file-csv"></i> CSV
                            </a>
                            <a href="disa_aktar.php?format=txt<?php echo $query_string; ?>" class="btn btn-secondary">
                                <i class="fas fa-file-alt"></i> TXT
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <!-- Kullanıcı Listesi Tablosu -->
    <div class="card">
        <div class="card-header bg-info text-white">
            <h5 class="mb-0"><i class="fas fa-users"></i> Kullanıcı Listesi</h5>
        </div>
        <div class="card-body">
            <?php
            // Hata ayıklama için PHP hata raporlamasını aktifleştir
            ini_set('display_errors', 1);
            ini_set('display_startup_errors', 1);
            error_reporting(E_ALL);
            
            // Kullanıcı listesi sorgusu
            $kullanici_listesi_sorgu = "
                SELECT 
                    k.id,
                    k.telegram_id,
                    k.kullanici_adi,
                    k.ad,
                    k.soyad,
                    k.telefon,
                    k.kayit_tarihi,
                    IFNULL(COUNT(d.id), 0) as davet_sayisi
                FROM 
                    kullanicilar k
                LEFT JOIN 
                    davetler d ON k.id = d.davet_eden_id AND d.aktif = 1
                WHERE 
                    k.aktif = 1
            ";
            
            // Arama koşulu
            if (!empty($arama)) {
                $kullanici_listesi_sorgu .= " AND (k.telegram_id LIKE '%$arama%' OR k.kullanici_adi LIKE '%$arama%' OR k.telefon LIKE '%$arama%' OR k.ad LIKE '%$arama%' OR k.soyad LIKE '%$arama%')";
            }
            
            // Tarih filtreleme
            if (!empty($baslangic_tarihi) && !empty($bitis_tarihi)) {
                $kullanici_listesi_sorgu .= " AND (k.kayit_tarihi BETWEEN '$baslangic_tarihi 00:00:00' AND '$bitis_tarihi 23:59:59')";
            }
            
            // GROUP BY
            $kullanici_listesi_sorgu .= " GROUP BY k.id";
            
            // HAVING koşulu (minimum davet sayısı)
            if ($min_davet > 0) {
                $kullanici_listesi_sorgu .= " HAVING davet_sayisi >= $min_davet";
            }
            
            // Sıralama
            switch ($siralama) {
                case 'davet_sayisi_desc':
                    $kullanici_listesi_sorgu .= " ORDER BY davet_sayisi DESC";
                    break;
                case 'davet_sayisi_asc':
                    $kullanici_listesi_sorgu .= " ORDER BY davet_sayisi ASC";
                    break;
                case 'kayit_tarihi_desc':
                    $kullanici_listesi_sorgu .= " ORDER BY k.kayit_tarihi DESC";
                    break;
                case 'kayit_tarihi_asc':
                    $kullanici_listesi_sorgu .= " ORDER BY k.kayit_tarihi ASC";
                    break;
                default:
                    $kullanici_listesi_sorgu .= " ORDER BY davet_sayisi DESC";
            }
            
            // Hata ayıklama için sorguyu yazdır
            echo "<!-- SQL Sorgusu: " . htmlspecialchars($kullanici_listesi_sorgu) . " -->";
            
            // Toplam kayıt sayısını al
            $toplam_kayit_sorgu = "SELECT COUNT(*) as toplam FROM kullanicilar WHERE aktif = 1";
            $toplam_kayit_sonuc = $vt->query($toplam_kayit_sorgu);
            $toplam_kayit = $toplam_kayit_sonuc ? $toplam_kayit_sonuc->fetch_assoc()['toplam'] : 0;
            
            // Sayfalama için LIMIT ekle
            $kullanici_listesi_sorgu .= " LIMIT $offset, $limit";
            
            // Sorguyu çalıştır
            $kullanici_listesi_sonuc = $vt->query($kullanici_listesi_sorgu);
            
            if (!$kullanici_listesi_sonuc) {
                echo '<div class="alert alert-danger">Sorgu hatası: ' . $vt->error . '</div>';
            }
            
            // Toplam sayfa sayısını hesapla
            $toplam_sayfa = ceil($toplam_kayit / $limit);
            ?>
            
            <?php if ($kullanici_listesi_sonuc && $kullanici_listesi_sonuc->num_rows > 0): ?>
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>#</th>
                                <th>Telegram ID</th>
                                <th>Kullanıcı Adı</th>
                                <th>Ad</th>
                                <th>Soyad</th>
                                <th>Telefon</th>
                                <th>Kayıt Tarihi</th>
                                <th>Davet Sayısı</th>
                                <th>Ödül Durumu</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $sira = ($sayfa - 1) * $limit + 1;
                            while ($kullanici = $kullanici_listesi_sonuc->fetch_assoc()): 
                                // Ödül durumu
                                $odul_durumu = '';
                                if ($kullanici['davet_sayisi'] >= $min_davet_sayisi) {
                                    $odul_durumu = '<span class="badge bg-success">Ödül Kazandı</span>';
                                    
                                    // Ekstra ödül hesapla
                                    if ($kullanici['davet_sayisi'] > $min_davet_sayisi) {
                                        $ekstra_davet = $kullanici['davet_sayisi'] - $min_davet_sayisi;
                                        $ekstra_odul_miktari = isset($ayarlar['EKSTRA_ODUL_MIKTARI']) ? intval($ayarlar['EKSTRA_ODUL_MIKTARI']) : 100;
                                        $ekstra_odul = $ekstra_davet * $ekstra_odul_miktari;
                                        $odul_durumu .= '<br><span class="badge bg-warning text-dark">+' . number_format($ekstra_odul, 0, ',', '.') . ' TL</span>';
                                    }
                                } else {
                                    $kalan = $min_davet_sayisi - $kullanici['davet_sayisi'];
                                    $odul_durumu = '<span class="badge bg-secondary">' . $kalan . ' Davet Kaldı</span>';
                                }
                            ?>
                                <tr>
                                    <td><?php echo $sira++; ?></td>
                                    <td><?php echo htmlspecialchars($kullanici['telegram_id']); ?></td>
                                    <td><?php echo htmlspecialchars($kullanici['kullanici_adi']); ?></td>
                                    <td><?php echo htmlspecialchars($kullanici['ad']); ?></td>
                                    <td><?php echo htmlspecialchars($kullanici['soyad']); ?></td>
                                    <td><?php echo $kullanici['telefon'] !== null ? htmlspecialchars($kullanici['telefon']) : ''; ?></td>
                                    <td><?php echo date('d.m.Y', strtotime($kullanici['kayit_tarihi'])); ?></td>
                                    <td>
                                        <span class="badge bg-primary"><?php echo $kullanici['davet_sayisi']; ?></span>
                                    </td>
                                    <td><?php echo $odul_durumu; ?></td>
                                    <td>
                                        <a href="kullanici_detay.php?id=<?php echo $kullanici['id']; ?>" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Sayfalama -->
                <?php if ($toplam_sayfa > 1): ?>
                    <nav aria-label="Sayfalama">
                        <ul class="pagination justify-content-center">
                            <?php
                            // Önceki sayfa linki
                            $onceki_sayfa = $sayfa > 1 ? $sayfa - 1 : 1;
                            $onceki_link = $_SERVER['PHP_SELF'] . '?' . http_build_query(array_merge($_GET, ['sayfa' => $onceki_sayfa]));
                            
                            // Sonraki sayfa linki
                            $sonraki_sayfa = $sayfa < $toplam_sayfa ? $sayfa + 1 : $toplam_sayfa;
                            $sonraki_link = $_SERVER['PHP_SELF'] . '?' . http_build_query(array_merge($_GET, ['sayfa' => $sonraki_sayfa]));
                            ?>
                            
                            <li class="page-item <?php echo $sayfa == 1 ? 'disabled' : ''; ?>">
                                <a class="page-link" href="<?php echo $onceki_link; ?>" aria-label="Önceki">
                                    <span aria-hidden="true">&laquo;</span>
                                </a>
                            </li>
                            
                            <?php
                            // Sayfa numaraları
                            $baslangic_sayfa = max(1, $sayfa - 2);
                            $bitis_sayfa = min($toplam_sayfa, $sayfa + 2);
                            
                            for ($i = $baslangic_sayfa; $i <= $bitis_sayfa; $i++): 
                                $sayfa_link = $_SERVER['PHP_SELF'] . '?' . http_build_query(array_merge($_GET, ['sayfa' => $i]));
                            ?>
                                <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                                    <a class="page-link" href="<?php echo $sayfa_link; ?>"><?php echo $i; ?></a>
                                </li>
                            <?php endfor; ?>
                            
                            <li class="page-item <?php echo $sayfa == $toplam_sayfa ? 'disabled' : ''; ?>">
                                <a class="page-link" href="<?php echo $sonraki_link; ?>" aria-label="Sonraki">
                                    <span aria-hidden="true">&raquo;</span>
                                </a>
                            </li>
                        </ul>
                    </nav>
                <?php endif; ?>
                
                <div class="text-center mt-3">
                    <p class="text-muted">
                        Toplam <?php echo $toplam_kayit; ?> kullanıcı | 
                        Sayfa <?php echo $sayfa; ?>/<?php echo $toplam_sayfa; ?> | 
                        Sayfa başına <?php echo $limit; ?> kayıt
                    </p>
                </div>
            <?php else: ?>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i> Belirtilen kriterlere uygun kullanıcı bulunamadı.
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
