<?php
session_start();
require_once '../bot/config.php';

// Zaten giriş yapılmışsa yönlendir
if (isset($_SESSION['admin_id'])) {
    header('Location: dashboard.php');
    exit;
}

$hata = '';

// Giriş formu gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $kullanici_adi = $_POST['kullanici_adi'] ?? '';
    $sifre = $_POST['sifre'] ?? '';
    
    // Kimlik bilgilerini doğrula
    $stmt = $vt->prepare("SELECT id, sifre FROM yoneticiler WHERE kullanici_adi = ?");
    $stmt->bind_param("s", $kullanici_adi);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($row = $result->fetch_assoc()) {
        if (password_verify($sifre, $row['sifre'])) {
            // Giriş başarılı
            $_SESSION['admin_id'] = $row['id'];
            $_SESSION['admin_kullanici_adi'] = $kullanici_adi;
            
            // Son giriş zamanını güncelle
            $stmt = $vt->prepare("UPDATE yoneticiler SET son_giris = NOW() WHERE id = ?");
            $stmt->bind_param("i", $row['id']);
            $stmt->execute();
            
            header('Location: dashboard.php');
            exit;
        } else {
            $hata = 'Geçersiz şifre';
        }
    } else {
        $hata = 'Kullanıcı bulunamadı';
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Betplay Davet Turnuvası - Yönetici Girişi</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-container {
            max-width: 400px;
            padding: 30px;
            background: white;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
            width: 100%;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <h2>Betplay Davet Turnuvası</h2>
            <p>Yönetim Paneli</p>
        </div>
        
        <?php if (!empty($hata)): ?>
            <div class="alert alert-danger"><?php echo $hata; ?></div>
        <?php endif; ?>
        
        <form method="post">
            <div class="form-group">
                <label for="kullanici_adi">Kullanıcı Adı</label>
                <input type="text" class="form-control" id="kullanici_adi" name="kullanici_adi" required>
            </div>
            <div class="form-group">
                <label for="sifre">Şifre</label>
                <input type="password" class="form-control" id="sifre" name="sifre" required>
            </div>
            <button type="submit" class="btn btn-primary">Giriş Yap</button>
        </form>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
