<?php
/**
 * Yönetim paneli üst bölüm
 */
require_once 'auth.php';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Betplay Davet Turnuvası - Yönetim Paneli</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #FABF08;
            --primary-dark: #e0a800;
            --secondary-color: #343a40;
            --text-color: #333;
            --light-bg: #f8f9fa;
            --card-shadow: 0 8px 16px rgba(0,0,0,0.1);
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f5f7fa;
            color: var(--text-color);
        }
        
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #343a40 0%, #121416 100%);
            color: white;
            padding-top: 20px;
            box-shadow: 3px 0 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            height: 100vh;
            overflow-y: auto;
        }
        
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.75);
            padding: 12px 15px;
            border-radius: 20px;
            margin: 8px 10px;
            transition: all 0.3s ease;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            background: rgba(255, 255, 255, 0.05);
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            font-size: 0.9rem;
        }
        
        .sidebar .nav-link:hover {
            color: white;
            background-color: rgba(255, 255, 255, 0.15);
            transform: translateX(5px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }
        
        .sidebar .nav-link.active {
            background-color: var(--primary-color);
            color: var(--secondary-color);
            font-weight: 500;
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }
        
        .sidebar .nav-link i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        
        .content {
            padding: 25px;
        }
        
        .navbar {
            background: linear-gradient(90deg, var(--primary-color) 0%, var(--primary-dark) 100%) !important;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            padding: 12px 20px;
        }
        
        .navbar-brand, .navbar-text {
            color: var(--secondary-color) !important;
            font-weight: 600;
        }
        
        .navbar-brand {
            font-size: 1.4rem;
        }
        
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: var(--card-shadow);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            margin-bottom: 25px;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 20px rgba(0,0,0,0.15);
        }
        
        .card-header {
            border-bottom: none;
            padding: 20px 25px;
            font-weight: 600;
            border-radius: 15px 15px 0 0 !important;
        }
        
        .card-body {
            padding: 25px;
        }
        
        .btn {
            border-radius: 8px;
            padding: 8px 20px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            color: var(--secondary-color);
        }
        
        .btn-primary:hover {
            background-color: var(--primary-dark);
            border-color: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        
        .table {
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 8px rgba(0,0,0,0.05);
        }
        
        .table thead th {
            background-color: var(--light-bg);
            border-bottom: 2px solid var(--primary-color);
            color: var(--secondary-color);
            font-weight: 600;
        }
        
        .form-control {
            border-radius: 8px;
            padding: 10px 15px;
            border: 1px solid #ced4da;
            transition: all 0.3s ease;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(250, 191, 8, 0.25);
        }
        
        /* Özel renk sınıfları */
        .bg-primary {
            background-color: var(--primary-color) !important;
        }
        
        .text-primary {
            color: var(--primary-color) !important;
        }
        
        /* Animasyonlar */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .fade-in {
            animation: fadeIn 0.5s ease-out forwards;
        }
        
        /* Responsive ayarlamalar */
        @media (max-width: 992px) {
            .sidebar {
                min-height: auto;
                height: auto;
                position: relative;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-light">
        <a class="navbar-brand" href="dashboard.php">
            <i class="fas fa-dice-d20 mr-2"></i>Betplay Davet Turnuvası
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <span class="navbar-text mr-3">
                        <i class="fas fa-user-circle mr-1"></i> <?php echo htmlspecialchars($_SESSION['admin_kullanici_adi']); ?>
                    </span>
                </li>
                <li class="nav-item">
                    <a class="nav-link btn btn-outline-dark btn-sm ml-2" href="cikis.php">
                        <i class="fas fa-sign-out-alt"></i> Çıkış
                    </a>
                </li>
            </ul>
        </div>
    </nav>
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-2 sidebar">
                <div class="text-center mb-4">
                    <img src="../assets/logo.png" alt="Logo" class="img-fluid" style="max-width: 120px; margin: 15px auto;">
                </div>
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>" href="dashboard.php">
                            <i class="fas fa-tachometer-alt"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'kullanicilar.php' ? 'active' : ''; ?>" href="kullanicilar.php">
                            <i class="fas fa-users"></i> Kullanıcılar
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'davetler.php' ? 'active' : ''; ?>" href="davetler.php">
                            <i class="fas fa-user-plus"></i> Davetler
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'oduller.php' ? 'active' : ''; ?>" href="oduller.php">
                            <i class="fas fa-trophy"></i> Ödüller
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'bildirimler.php' ? 'active' : ''; ?>" href="bildirimler.php">
                            <i class="fas fa-bell"></i> Bildirimler
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'bot_ayarlari.php' ? 'active' : ''; ?>" href="bot_ayarlari.php">
                            <i class="fas fa-robot"></i> Bot Ayarları
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'kanallar.php' ? 'active' : ''; ?>" href="kanallar.php">
                            <i class="fas fa-bullhorn"></i> Kanallar
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'kurallar.php' ? 'active' : ''; ?>" href="kurallar.php">
                            <i class="fas fa-scroll"></i> Kurallar
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'istatistikler.php' ? 'active' : ''; ?>" href="istatistikler.php">
                            <i class="fas fa-chart-bar"></i> İstatistikler
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'ayarlar.php' ? 'active' : ''; ?>" href="ayarlar.php">
                            <i class="fas fa-cog"></i> Ayarlar
                        </a>
                    </li>
                </ul>
            </div>
            
            <div class="col-md-10 content fade-in">
                <!-- İçerik buraya gelecek -->
