<?php
/**
 * Betplay Davet Turnuvası - Yönetim Paneli
 * Dışa Aktarma Sayfası
 */
require_once '../bot/config.php';
require_once 'includes/auth.php';

// Parametreleri al
$export_format = isset($_GET['format']) ? $_GET['format'] : 'excel';
$baslangic_tarihi = isset($_GET['baslangic_tarihi']) ? $_GET['baslangic_tarihi'] : '';
$bitis_tarihi = isset($_GET['bitis_tarihi']) ? $_GET['bitis_tarihi'] : '';
$min_davet = isset($_GET['min_davet']) ? intval($_GET['min_davet']) : 0;
$arama = isset($_GET['arama']) ? $_GET['arama'] : '';
$siralama = isset($_GET['siralama']) ? $_GET['siralama'] : 'davet_sayisi_desc';

// Minimum davet sayısını veritabanından çek
$min_davet_sayisi = isset($ayarlar['MIN_DAVET_SAYISI']) ? intval($ayarlar['MIN_DAVET_SAYISI']) : 5;

// Kullanıcı listesi sorgusu (LIMIT olmadan tüm kayıtları al)
$export_sorgu = "
    SELECT 
        k.telegram_id,
        k.kullanici_adi,
        k.ad,
        k.soyad,
        k.telefon,
        k.kayit_tarihi,
        COUNT(d.id) as davet_sayisi
    FROM 
        kullanicilar k
    LEFT JOIN 
        davetler d ON k.id = d.davet_eden_id AND d.aktif = 1
";

// WHERE koşulları
$where_kosullari = ["k.aktif = 1"];

if (!empty($arama)) {
    $where_kosullari[] = "(k.telegram_id LIKE '%$arama%' OR k.kullanici_adi LIKE '%$arama%' OR k.telefon LIKE '%$arama%' OR k.ad LIKE '%$arama%' OR k.soyad LIKE '%$arama%')";
}

if (!empty($baslangic_tarihi) && !empty($bitis_tarihi)) {
    $where_kosullari[] = "(k.kayit_tarihi BETWEEN '$baslangic_tarihi 00:00:00' AND '$bitis_tarihi 23:59:59')";
}

if (!empty($where_kosullari)) {
    $export_sorgu .= " WHERE " . implode(" AND ", $where_kosullari);
}

// GROUP BY ve ORDER BY
$export_sorgu .= " GROUP BY k.id";

// HAVING koşulu (minimum davet sayısı)
if ($min_davet > 0) {
    $export_sorgu .= " HAVING davet_sayisi >= $min_davet";
}

// Sıralama
switch ($siralama) {
    case 'davet_sayisi_desc':
        $export_sorgu .= " ORDER BY davet_sayisi DESC";
        break;
    case 'davet_sayisi_asc':
        $export_sorgu .= " ORDER BY davet_sayisi ASC";
        break;
    case 'kayit_tarihi_desc':
        $export_sorgu .= " ORDER BY k.kayit_tarihi DESC";
        break;
    case 'kayit_tarihi_asc':
        $export_sorgu .= " ORDER BY k.kayit_tarihi ASC";
        break;
    default:
        $export_sorgu .= " ORDER BY davet_sayisi DESC";
}

// Sorguyu çalıştır
$export_sonuc = $vt->query($export_sorgu);

if ($export_sonuc && $export_sonuc->num_rows > 0) {
    // Dosya adı
    $dosya_adi = 'betplay_davet_turnuvasi_' . date('Y-m-d_H-i-s');
    
    // Başlık satırı
    $basliklar = ['Telegram ID', 'Kullanıcı Adı', 'Ad', 'Soyad', 'Telefon', 'Kayıt Tarihi', 'Davet Sayısı', 'Ödül Durumu', 'Ekstra Ödül (TL)'];
    
    // Veri satırları
    $veriler = [];
    while ($kullanici = $export_sonuc->fetch_assoc()) {
        // Ödül durumu
        $odul_durumu = $kullanici['davet_sayisi'] >= $min_davet_sayisi ? 'Ödül Kazandı' : 'Kazanamadı';
        
        // Ekstra ödül
        $ekstra_odul = 0;
        if ($kullanici['davet_sayisi'] > $min_davet_sayisi) {
            $ekstra_davet = $kullanici['davet_sayisi'] - $min_davet_sayisi;
            $ekstra_odul_miktari = isset($ayarlar['EKSTRA_ODUL_MIKTARI']) ? intval($ayarlar['EKSTRA_ODUL_MIKTARI']) : 100;
            $ekstra_odul = $ekstra_davet * $ekstra_odul_miktari;
        }
        
        $veriler[] = [
            $kullanici['telegram_id'],
            $kullanici['kullanici_adi'],
            $kullanici['ad'],
            $kullanici['soyad'],
            $kullanici['telefon'] !== null ? $kullanici['telefon'] : '',
            date('d.m.Y', strtotime($kullanici['kayit_tarihi'])),
            $kullanici['davet_sayisi'],
            $odul_durumu,
            $ekstra_odul
        ];
    }
    
    // Dışa aktarma formatına göre işlem yap
    switch ($export_format) {
        case 'excel':
            // Excel formatı için gerekli başlıklar
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$dosya_adi.xls\"");
            header("Pragma: no-cache");
            header("Expires: 0");
            
            // Excel içeriği oluştur
            echo "<html xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:x=\"urn:schemas-microsoft-com:office:excel\" xmlns=\"http://www.w3.org/TR/REC-html40\">";
            echo "<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body>";
            echo "<table border=\"1\">";
            
            // Başlık satırı
            echo "<tr>";
            foreach ($basliklar as $baslik) {
                echo "<th>$baslik</th>";
            }
            echo "</tr>";
            
            // Veri satırları
            foreach ($veriler as $satir) {
                echo "<tr>";
                foreach ($satir as $hucre) {
                    echo "<td>$hucre</td>";
                }
                echo "</tr>";
            }
            
            echo "</table></body></html>";
            exit;
            
        case 'csv':
            // CSV formatı için gerekli başlıklar
            header("Content-Type: application/octet-stream");
            header("Content-Disposition: attachment; filename=\"$dosya_adi.csv\"");
            header("Pragma: no-cache");
            header("Expires: 0");
            
            // CSV içeriği oluştur
            $output = fopen('php://output', 'w');
            
            // UTF-8 BOM
            fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));
            
            // Başlık satırı
            fputcsv($output, $basliklar);
            
            // Veri satırları
            foreach ($veriler as $satir) {
                fputcsv($output, $satir);
            }
            
            fclose($output);
            exit;
            
        case 'txt':
            // TXT formatı için gerekli başlıklar
            header("Content-Type: application/octet-stream");
            header("Content-Disposition: attachment; filename=\"$dosya_adi.txt\"");
            header("Pragma: no-cache");
            header("Expires: 0");
            
            // TXT içeriği oluştur
            $output = '';
            
            // Başlık satırı
            $output .= implode("\t", $basliklar) . "\n";
            
            // Veri satırları
            foreach ($veriler as $satir) {
                $output .= implode("\t", $satir) . "\n";
            }
            
            echo $output;
            exit;
    }
} else {
    // Veri yoksa ana sayfaya yönlendir
    header("Location: istatistikler.php?hata=veri_yok");
    exit;
}
?>
