<?php
/**
 * Betplay Davet Turnuvası - Yönetim Paneli
 * Davetler Sayfası
 */
require_once '../bot/config.php';
require_once 'includes/header.php';

// Sayfalama için değişkenler
$sayfa = isset($_GET['sayfa']) ? (int)$_GET['sayfa'] : 1;
$limit = 20;
$offset = ($sayfa - 1) * $limit;

// Arama filtresi
$arama = isset($_GET['arama']) ? $vt->real_escape_string($_GET['arama']) : '';
$arama_filtresi = '';
if (!empty($arama)) {
    $arama_filtresi = " WHERE 
        k1.telegram_id LIKE '%$arama%' OR 
        k1.kullanici_adi LIKE '%$arama%' OR 
        k2.telegram_id LIKE '%$arama%' OR 
        k2.kullanici_adi LIKE '%$arama%'";
}

// Toplam davet sayısını al
$toplam_sorgu = "
    SELECT COUNT(*) as toplam 
    FROM davetler d
    JOIN kullanicilar k1 ON d.davet_eden_id = k1.id
    JOIN kullanicilar k2 ON d.davet_edilen_id = k2.id
    $arama_filtresi
";
$toplam_sonuc = $vt->query($toplam_sorgu);
$toplam_satir = $toplam_sonuc->fetch_assoc()['toplam'];
$toplam_sayfa = ceil($toplam_satir / $limit);

// Davetleri al
$davetler_sorgu = "
    SELECT 
        d.*,
        k1.telegram_id as davet_eden_telegram_id,
        k1.kullanici_adi as davet_eden_kullanici_adi,
        k1.ad as davet_eden_ad,
        k1.soyad as davet_eden_soyad,
        k2.telegram_id as davet_edilen_telegram_id,
        k2.kullanici_adi as davet_edilen_kullanici_adi,
        k2.ad as davet_edilen_ad,
        k2.soyad as davet_edilen_soyad
    FROM 
        davetler d
    JOIN 
        kullanicilar k1 ON d.davet_eden_id = k1.id
    JOIN 
        kullanicilar k2 ON d.davet_edilen_id = k2.id
    $arama_filtresi
    ORDER BY 
        d.davet_tarihi DESC
    LIMIT $offset, $limit
";
$davetler = $vt->query($davetler_sorgu);

// Davet silme işlemi
if (isset($_POST['sil']) && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $vt->query("DELETE FROM davetler WHERE id = $id");
    header('Location: davetler.php');
    exit;
}

// Davet durumunu değiştirme
if (isset($_POST['durum_degistir']) && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $yeni_durum = (int)$_POST['yeni_durum'];
    $vt->query("UPDATE davetler SET aktif = $yeni_durum WHERE id = $id");
    header('Location: davetler.php');
    exit;
}
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Davetler</h1>
        <div class="d-flex">
            <form class="form-inline mr-2">
                <div class="input-group">
                    <input type="text" class="form-control" placeholder="Ara..." name="arama" value="<?php echo htmlspecialchars($arama); ?>">
                    <div class="input-group-append">
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Davet Eden</th>
                            <th>Davet Edilen</th>
                            <th>Davet Tarihi</th>
                            <th>Durum</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($davet = $davetler->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $davet['id']; ?></td>
                                <td>
                                    <?php if (!empty($davet['davet_eden_kullanici_adi'])): ?>
                                        @<?php echo htmlspecialchars($davet['davet_eden_kullanici_adi']); ?>
                                    <?php else: ?>
                                        <?php echo htmlspecialchars($davet['davet_eden_ad'] . ' ' . $davet['davet_eden_soyad']); ?>
                                    <?php endif; ?>
                                    <br>
                                    <small class="text-muted">ID: <?php echo $davet['davet_eden_telegram_id']; ?></small>
                                </td>
                                <td>
                                    <?php if (!empty($davet['davet_edilen_kullanici_adi'])): ?>
                                        @<?php echo htmlspecialchars($davet['davet_edilen_kullanici_adi']); ?>
                                    <?php else: ?>
                                        <?php echo htmlspecialchars($davet['davet_edilen_ad'] . ' ' . $davet['davet_edilen_soyad']); ?>
                                    <?php endif; ?>
                                    <br>
                                    <small class="text-muted">ID: <?php echo $davet['davet_edilen_telegram_id']; ?></small>
                                </td>
                                <td><?php echo date('d.m.Y H:i', strtotime($davet['davet_tarihi'])); ?></td>
                                <td>
                                    <?php if ($davet['aktif']): ?>
                                        <span class="badge badge-success">Aktif</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger">Pasif</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <form method="post" class="d-inline" onsubmit="return confirm('Davet durumunu değiştirmek istediğinize emin misiniz?');">
                                            <input type="hidden" name="id" value="<?php echo $davet['id']; ?>">
                                            <input type="hidden" name="yeni_durum" value="<?php echo $davet['aktif'] ? 0 : 1; ?>">
                                            <button type="submit" name="durum_degistir" class="btn btn-sm btn-<?php echo $davet['aktif'] ? 'warning' : 'success'; ?>">
                                                <i class="fas fa-<?php echo $davet['aktif'] ? 'ban' : 'check'; ?>"></i>
                                            </button>
                                        </form>
                                        <form method="post" class="d-inline" onsubmit="return confirm('Bu daveti silmek istediğinize emin misiniz?');">
                                            <input type="hidden" name="id" value="<?php echo $davet['id']; ?>">
                                            <button type="submit" name="sil" class="btn btn-sm btn-danger">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if ($toplam_sayfa > 1): ?>
                <nav>
                    <ul class="pagination justify-content-center">
                        <?php if ($sayfa > 1): ?>
                            <li class="page-item">
                                <a class="page-link" href="?sayfa=<?php echo $sayfa - 1; ?><?php echo !empty($arama) ? '&arama=' . urlencode($arama) : ''; ?>">
                                    <i class="fas fa-chevron-left"></i>
                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <?php for ($i = max(1, $sayfa - 2); $i <= min($toplam_sayfa, $sayfa + 2); $i++): ?>
                            <li class="page-item <?php echo $i == $sayfa ? 'active' : ''; ?>">
                                <a class="page-link" href="?sayfa=<?php echo $i; ?><?php echo !empty($arama) ? '&arama=' . urlencode($arama) : ''; ?>">
                                    <?php echo $i; ?>
                                </a>
                            </li>
                        <?php endfor; ?>
                        
                        <?php if ($sayfa < $toplam_sayfa): ?>
                            <li class="page-item">
                                <a class="page-link" href="?sayfa=<?php echo $sayfa + 1; ?><?php echo !empty($arama) ? '&arama=' . urlencode($arama) : ''; ?>">
                                    <i class="fas fa-chevron-right"></i>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
