<?php
/**
 * Betplay Davet Turnuvası - Yönetim Paneli
 * Gösterge Paneli
 */
require_once '../bot/config.php';
require_once 'includes/header.php';

// Turnuva istatistiklerini al
$istatistikler = [];

// Bugünkü davetleri hesapla
$bugun = date('Y-m-d');
$result = $vt->query("
    SELECT COUNT(*) as toplam 
    FROM davetler 
    WHERE DATE(davet_tarihi) = '$bugun'
");
$istatistikler['bugun_davetler'] = $result->fetch_assoc()['toplam'] ?? 0;

// Son 7 gündeki davetler
$son_7_gun = date('Y-m-d', strtotime('-7 days'));
$result = $vt->query("
    SELECT COUNT(*) as toplam 
    FROM davetler 
    WHERE davet_tarihi BETWEEN '$son_7_gun 00:00:00' AND NOW()
");
$istatistikler['son_7_gun_davetler'] = $result->fetch_assoc()['toplam'] ?? 0;

// Toplam kullanıcılar
$result = $vt->query("SELECT COUNT(*) as toplam FROM kullanicilar");
$istatistikler['toplam_kullanicilar'] = $result->fetch_assoc()['toplam'];

// Toplam davetler
$result = $vt->query("SELECT COUNT(*) as toplam FROM davetler");
$istatistikler['toplam_davetler'] = $result->fetch_assoc()['toplam'];

// Minimum davet sayısı ve ödül miktarlarını al
$min_davet_sayisi = minDavetSayisiAl();
$freebet_miktari = freebetMiktariAl();
$ekstra_odul_miktari = ekstraOdulMiktariAl();

// 5+ davet eden kullanıcılar
$result = $vt->query("
    SELECT COUNT(*) as toplam FROM (
        SELECT k.telegram_id, COUNT(d.id) as davet_sayisi
        FROM kullanicilar k
        JOIN davetler d ON k.telegram_id = d.davet_eden_id
        GROUP BY k.telegram_id
        HAVING davet_sayisi >= $min_davet_sayisi
    ) as nitelikli_kullanicilar
");
$istatistikler['kullanicilar_5plus'] = $result->fetch_assoc()['toplam'] ?? 0;

// Toplam freebet ödülleri
$istatistikler['toplam_freebet'] = $istatistikler['kullanicilar_5plus'] * $freebet_miktari;

// Ekstra nakit ödülleri hesapla
$result = $vt->query("
    SELECT SUM(IF(davet_sayisi > $min_davet_sayisi, (davet_sayisi - $min_davet_sayisi) * $ekstra_odul_miktari, 0)) as toplam_ekstra
    FROM (
        SELECT k.telegram_id, COUNT(d.id) as davet_sayisi
        FROM kullanicilar k
        JOIN davetler d ON k.telegram_id = d.davet_eden_id
        GROUP BY k.telegram_id
    ) as kullanici_davetleri
");
$istatistikler['toplam_ekstra_nakit'] = $result->fetch_assoc()['toplam_ekstra'] ?? 0;

// İlk 5 için ödüller
$ust_oduller = ustOdulleriAl();
$toplam_ust_odul = 0;
foreach ($ust_oduller as $odul) {
    $toplam_ust_odul += $odul['odul'];
}
$istatistikler['toplam_ust_oduller'] = $toplam_ust_odul;

// Toplam ödül miktarı
$istatistikler['toplam_odul'] = $istatistikler['toplam_freebet'] + $istatistikler['toplam_ekstra_nakit'] + $istatistikler['toplam_ust_oduller'];

// Son 5 kullanıcı
$son_kullanicilar = $vt->query("
    SELECT telegram_id, kullanici_adi, ad, soyad, kayit_tarihi
    FROM kullanicilar
    ORDER BY kayit_tarihi DESC
    LIMIT 5
");

// En çok davet eden 5 kullanıcı
$en_cok_davet_edenler = $vt->query("
    SELECT 
        k.telegram_id,
        k.kullanici_adi,
        k.ad,
        k.soyad,
        COUNT(d.id) as davet_sayisi
    FROM 
        kullanicilar k
    LEFT JOIN 
        davetler d ON k.telegram_id = d.davet_eden_id
    GROUP BY 
        k.telegram_id
    ORDER BY 
        davet_sayisi DESC
    LIMIT 5
");

// Son 5 davet
$son_davetler = $vt->query("
    SELECT 
        d.davet_tarihi,
        k1.kullanici_adi as davet_eden_kullanici_adi,
        k1.telegram_id as davet_eden_telegram_id,
        k2.kullanici_adi as davet_edilen_kullanici_adi,
        k2.telegram_id as davet_edilen_telegram_id
    FROM 
        davetler d
    JOIN 
        kullanicilar k1 ON d.davet_eden_id = k1.telegram_id
    JOIN 
        kullanicilar k2 ON d.davet_edilen_id = k2.telegram_id
    ORDER BY 
        d.davet_tarihi DESC
    LIMIT 5
");

// Turnuva durumu
$turnuva_aktif = turnuvaAktifMi();
$simdi = new DateTime();
$baslangic = new DateTime(ayarAl('TURNUVA_BASLANGIC', '2025-04-23 00:01:00'));
$bitis = new DateTime(ayarAl('TURNUVA_BITIS', '2025-05-03 23:59:59'));

if ($simdi < $baslangic) {
    $turnuva_durumu = "Başlamadı";
    $kalan_sure = $simdi->diff($baslangic);
    $kalan_sure_metin = $kalan_sure->format('%a gün, %h saat, %i dakika');
} elseif ($simdi > $bitis) {
    $turnuva_durumu = "Sona Erdi";
    $kalan_sure_metin = "Turnuva sona erdi";
} else {
    $turnuva_durumu = "Aktif";
    $kalan_sure = $simdi->diff($bitis);
    $kalan_sure_metin = $kalan_sure->format('%a gün, %h saat, %i dakika');
}
?>

<div class="container-fluid px-4">
    <h1 class="mt-4">Gösterge Paneli</h1>
    
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card bg-primary text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title"><i class="fas fa-users me-2"></i> Toplam Kullanıcı</h5>
                            <h2 class="mb-0"><?php echo number_format($istatistikler['toplam_kullanicilar']); ?></h2>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="kullanicilar.php">Detayları Görüntüle</a>
                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-success text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title"><i class="fas fa-handshake me-2"></i> Toplam Davetler</h5>
                            <h2 class="mb-0"><?php echo number_format($istatistikler['toplam_davetler']); ?></h2>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="davetler.php">Detayları Görüntüle</a>
                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-warning text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title"><i class="fas fa-calendar-day me-2"></i> Bugünkü Davet</h5>
                            <h2 class="mb-0"><?php echo number_format($istatistikler['bugun_davetler']); ?></h2>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="istatistikler.php">Detayları Görüntüle</a>
                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-danger text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title"><i class="fas fa-trophy me-2"></i> Toplam Ödül</h5>
                            <h2 class="mb-0"><?php echo number_format($istatistikler['toplam_odul']); ?> TL</h2>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="oduller.php">Detayları Görüntüle</a>
                    <div class="small text-white"><i class="fas fa-angle-right"></i></div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-calendar-alt me-2"></i> Turnuva Durumu</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <div class="d-flex align-items-center mb-2">
                                    <span class="badge <?php echo $turnuva_durumu == 'Aktif' ? 'bg-success' : ($turnuva_durumu == 'Başlamadı' ? 'bg-warning' : 'bg-secondary'); ?> me-2">
                                        <?php echo $turnuva_durumu; ?>
                                    </span>
                                    <h5 class="mb-0">Durum</h5>
                                </div>
                                <p class="text-muted small mb-0">
                                    <?php echo $kalan_sure_metin; ?>
                                </p>
                            </div>
                            
                            <div class="mb-3">
                                <h5 class="mb-1">Başlangıç</h5>
                                <p class="text-muted mb-0">
                                    <i class="far fa-calendar-alt me-1"></i>
                                    <?php echo $baslangic->format('d.m.Y'); ?>
                                    <i class="far fa-clock ms-2 me-1"></i>
                                    <?php echo $baslangic->format('H:i'); ?>
                                </p>
                            </div>
                            
                            <div class="mb-3">
                                <h5 class="mb-1">Bitiş</h5>
                                <p class="text-muted mb-0">
                                    <i class="far fa-calendar-alt me-1"></i>
                                    <?php echo $bitis->format('d.m.Y'); ?>
                                    <i class="far fa-clock ms-2 me-1"></i>
                                    <?php echo $bitis->format('H:i'); ?>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5 class="mb-3">Ödül Dağılımı</h5>
                            <div class="list-group">
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <span><i class="fas fa-ticket-alt text-success me-2"></i> Freebet</span>
                                    <span class="badge bg-success rounded-pill"><?php echo number_format($istatistikler['toplam_freebet']); ?> TL</span>
                                </div>
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <span><i class="fas fa-coins text-warning me-2"></i> Ekstra Nakit</span>
                                    <span class="badge bg-warning text-dark rounded-pill"><?php echo number_format($istatistikler['toplam_ekstra_nakit']); ?> TL</span>
                                </div>
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <span><i class="fas fa-trophy text-danger me-2"></i> Üst Ödüller</span>
                                    <span class="badge bg-danger rounded-pill"><?php echo number_format($istatistikler['toplam_ust_oduller']); ?> TL</span>
                                </div>
                                <div class="list-group-item d-flex justify-content-between align-items-center list-group-item-primary">
                                    <strong><i class="fas fa-money-bill-wave me-2"></i> Toplam</strong>
                                    <span class="badge bg-primary rounded-pill"><?php echo number_format($istatistikler['toplam_odul']); ?> TL</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="fas fa-award me-3"></i> En Çok Davet Eden Kullanıcılar</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th width="60">#</th>
                                    <th>Kullanıcı</th>
                                    <th>Telegram ID</th>
                                    <th class="text-end">Davet</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $sira = 1; while ($kullanici = $en_cok_davet_edenler->fetch_assoc()): ?>
                                    <tr>
                                        <td>
                                            <span class="badge <?php 
                                                if ($sira == 1) echo 'bg-warning'; 
                                                else if ($sira == 2) echo 'bg-secondary'; 
                                                else if ($sira == 3) echo 'bg-danger';
                                                else echo 'bg-primary';
                                            ?>">
                                                <?php echo $sira++; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php if (!empty($kullanici['kullanici_adi'])): ?>
                                                <strong>@<?php echo htmlspecialchars($kullanici['kullanici_adi']); ?></strong>
                                            <?php else: ?>
                                                <strong><?php echo htmlspecialchars($kullanici['ad'] . ' ' . $kullanici['soyad']); ?></strong>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo $kullanici['telegram_id']; ?></td>
                                        <td class="text-end">
                                            <span class="badge bg-success"><?php echo $kullanici['davet_sayisi']; ?></span>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="text-end mt-3">
                        <a href="istatistikler.php" class="btn btn-sm btn-success">
                            <i class="fas fa-chart-bar me-1"></i> Tüm İstatistikleri Görüntüle
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="fas fa-user-plus me-4"></i> Son Kayıt Olan Kullanıcılar</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>Kullanıcı</th>
                                    <th>Telegram ID</th>
                                    <th>Kayıt Tarihi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($kullanici = $son_kullanicilar->fetch_assoc()): ?>
                                    <tr>
                                        <td>
                                            <?php if (!empty($kullanici['kullanici_adi'])): ?>
                                                <strong>@<?php echo htmlspecialchars($kullanici['kullanici_adi']); ?></strong>
                                            <?php else: ?>
                                                <strong><?php echo htmlspecialchars($kullanici['ad'] . ' ' . $kullanici['soyad']); ?></strong>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo $kullanici['telegram_id']; ?></td>
                                        <td>
                                            <i class="far fa-calendar-alt text-muted me-1"></i>
                                            <?php echo date('d.m.Y', strtotime($kullanici['kayit_tarihi'])); ?>
                                            <i class="far fa-clock text-muted ms-2 me-1"></i>
                                            <?php echo date('H:i', strtotime($kullanici['kayit_tarihi'])); ?>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="text-end mt-3">
                        <a href="kullanicilar.php" class="btn btn-sm btn-info">
                            <i class="fas fa-users me-1"></i> Tüm Kullanıcıları Görüntüle
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-warning text-white">
                    <h5 class="mb-0"><i class="fas fa-handshake me-2"></i> Son Davetler</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>Davet Eden</th>
                                    <th>Davet Edilen</th>
                                    <th>Tarih</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($davet = $son_davetler->fetch_assoc()): ?>
                                    <tr>
                                        <td>
                                            <?php if (!empty($davet['davet_eden_kullanici_adi'])): ?>
                                                <strong>@<?php echo htmlspecialchars($davet['davet_eden_kullanici_adi']); ?></strong>
                                            <?php else: ?>
                                                <span class="text-muted">ID: <?php echo $davet['davet_eden_telegram_id']; ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if (!empty($davet['davet_edilen_kullanici_adi'])): ?>
                                                <strong>@<?php echo htmlspecialchars($davet['davet_edilen_kullanici_adi']); ?></strong>
                                            <?php else: ?>
                                                <span class="text-muted">ID: <?php echo $davet['davet_edilen_telegram_id']; ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <i class="far fa-calendar-alt text-muted me-1"></i>
                                            <?php echo date('d.m.Y', strtotime($davet['davet_tarihi'])); ?>
                                            <i class="far fa-clock text-muted ms-2 me-1"></i>
                                            <?php echo date('H:i', strtotime($davet['davet_tarihi'])); ?>
                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="text-end mt-3">
                        <a href="davetler.php" class="btn btn-sm btn-warning text-white">
                            <i class="fas fa-handshake me-1"></i> Tüm Davetleri Görüntüle
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
