<?php
require_once 'includes/auth.php';
require_once '../bot/config.php';
require_once '../bot/BotAPI.php';

$baslik = "Bot Ayarları";
$mesaj = "";
$bot = new BotAPI(BOT_TOKEN);

// Bot bilgilerini al
$bot_bilgileri = $bot->botBilgileriniGetir();
$bot_aciklamasi = $bot->botAciklamasiniGetir();
$bot_kisa_aciklamasi = $bot->botKisaAciklamasiniGetir();
$bot_komutlari = $bot->botKomutlariniGetir();

// Webhook durumunu kontrol et
$webhook_bilgisi = $bot->webhookBilgisiniGetir();
$webhook_aktif = isset($webhook_bilgisi['result']['url']) && !empty($webhook_bilgisi['result']['url']);
$webhook_url = $webhook_aktif ? $webhook_bilgisi['result']['url'] : '';

// Son webhook URL'sini veritabanından al (devre dışı bırakılsa bile)
$son_webhook_url = ayarAl('SON_WEBHOOK_URL', '');
if (empty($son_webhook_url) && !empty($webhook_url)) {
    // İlk kez çalıştırılıyorsa ve webhook aktifse, URL'yi kaydet
    $vt->query("INSERT INTO ayarlar (anahtar, deger) VALUES ('SON_WEBHOOK_URL', '" . $vt->real_escape_string($webhook_url) . "') ON DUPLICATE KEY UPDATE deger = VALUES(deger)");
    $son_webhook_url = $webhook_url;
}

// Kayıt URL ve buton metnini veritabanından al
$kayit_url = ayarAl('KAYIT_URL', '');
$kayit_buton_metni = ayarAl('KAYIT_BUTON_METNI', 'BetPlay\'e Giriş yap.');

// Form gönderildi mi kontrol et
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $islem = $_POST['islem'] ?? '';
    
    // Bot ismini güncelle
    if ($islem === 'isim_guncelle') {
        $bot_ismi = $_POST['bot_ismi'] ?? '';
        
        if (empty($bot_ismi)) {
            $mesaj = '<div class="alert alert-danger">Bot ismi boş olamaz.</div>';
        } else {
            $sonuc = $bot->botIsmiGuncelle($bot_ismi);
            
            if ($sonuc && $sonuc['ok']) {
                $mesaj = '<div class="alert alert-success">Bot ismi başarıyla güncellendi.</div>';
                // Bot bilgilerini yeniden al
                $bot_bilgileri = $bot->botBilgileriniGetir();
            } else {
                $mesaj = '<div class="alert alert-danger">Bot ismi güncellenirken bir hata oluştu.</div>';
            }
        }
    }
    
    // Bot açıklamasını güncelle
    if ($islem === 'aciklama_guncelle') {
        $bot_aciklama = $_POST['bot_aciklama'] ?? '';
        
        $sonuc = $bot->botAciklamasiGuncelle($bot_aciklama);
        
        if ($sonuc && $sonuc['ok']) {
            $mesaj = '<div class="alert alert-success">Bot açıklaması başarıyla güncellendi.</div>';
            // Bot açıklamasını yeniden al
            $bot_aciklamasi = $bot->botAciklamasiniGetir();
        } else {
            $mesaj = '<div class="alert alert-danger">Bot açıklaması güncellenirken bir hata oluştu.</div>';
        }
    }
    
    // Bot kısa açıklamasını güncelle
    if ($islem === 'kisa_aciklama_guncelle') {
        $bot_kisa_aciklama = $_POST['bot_kisa_aciklama'] ?? '';
        
        if (strlen($bot_kisa_aciklama) > 120) {
            $mesaj = '<div class="alert alert-danger">Bot kısa açıklaması en fazla 120 karakter olabilir.</div>';
        } else {
            $sonuc = $bot->botKisaAciklamasiGuncelle($bot_kisa_aciklama);
            
            if ($sonuc && $sonuc['ok']) {
                $mesaj = '<div class="alert alert-success">Bot kısa açıklaması başarıyla güncellendi.</div>';
                // Bot kısa açıklamasını yeniden al
                $bot_kisa_aciklamasi = $bot->botKisaAciklamasiniGetir();
            } else {
                $mesaj = '<div class="alert alert-danger">Bot kısa açıklaması güncellenirken bir hata oluştu.</div>';
            }
        }
    }
    
    // Bot komutlarını güncelle
    if ($islem === 'komutlar_guncelle') {
        $komutlar = [];
        $komut_sayisi = $_POST['komut_sayisi'] ?? 0;
        
        for ($i = 0; $i < $komut_sayisi; $i++) {
            $komut = $_POST['komut_' . $i] ?? '';
            $aciklama = $_POST['aciklama_' . $i] ?? '';
            
            if (!empty($komut) && !empty($aciklama)) {
                $komutlar[] = [
                    'command' => $komut,
                    'description' => $aciklama
                ];
            }
        }
        
        $sonuc = $bot->botKomutlariniGuncelle($komutlar);
        
        if ($sonuc && $sonuc['ok']) {
            $mesaj = '<div class="alert alert-success">Bot komutları başarıyla güncellendi.</div>';
            // Bot komutlarını yeniden al
            $bot_komutlari = $bot->botKomutlariniGetir();
        } else {
            $mesaj = '<div class="alert alert-danger">Bot komutları güncellenirken bir hata oluştu.</div>';
        }
    }
    
    // Bot profil fotoğrafını güncelle
    if ($islem === 'foto_guncelle' && isset($_FILES['bot_foto']) && $_FILES['bot_foto']['error'] === UPLOAD_ERR_OK) {
        $tmp_name = $_FILES['bot_foto']['tmp_name'];
        
        // BotAPI sınıfını kullanarak profil fotoğrafını güncelle
        $sonuc = $bot->botProfilFotografiGuncelle($tmp_name);
        
        if ($sonuc && $sonuc['ok']) {
            $mesaj = '<div class="alert alert-success">Bot profil fotoğrafı başarıyla güncellendi.</div>';
        } else {
            // Detaylı hata bilgisi göster
            $hata_mesaji = isset($sonuc['description']) ? $sonuc['description'] : 'Bilinmeyen hata';
            $hata_kodu = isset($sonuc['error_code']) ? $sonuc['error_code'] : '';
            $mesaj = '<div class="alert alert-danger">Bot profil fotoğrafı güncellenirken bir hata oluştu: ' . $hata_mesaji;
            if (!empty($hata_kodu)) {
                $mesaj .= ' (Hata Kodu: ' . $hata_kodu . ')';
            }
            $mesaj .= '<br><small>İpucu: Fotoğrafın kare şeklinde olduğundan ve boyutunun 640x640 piksel civarında olduğundan emin olun.</small>';
            $mesaj .= '</div>';
        }
    }
    
    // Kayıt URL butonunu güncelle
    else if ($islem === 'kayit_url_guncelle') {
        $kayit_url = $_POST['kayit_url'] ?? '';
        $buton_metni = $_POST['buton_metni'] ?? 'BetPlay\'e Giriş yap.';
        
        if (empty($kayit_url)) {
            $mesaj = '<div class="alert alert-danger">Kayıt URL\'si boş olamaz.</div>';
        } else {
            // Önce veritabanını güncelle
            $kayit_url_escaped = $vt->real_escape_string($kayit_url);
            $buton_metni_escaped = $vt->real_escape_string($buton_metni);
            
            // Ayarları güncelle
            $vt->query("INSERT INTO ayarlar (anahtar, deger) VALUES ('KAYIT_URL', '$kayit_url_escaped') 
                       ON DUPLICATE KEY UPDATE deger = VALUES(deger)");
            $vt->query("INSERT INTO ayarlar (anahtar, deger) VALUES ('KAYIT_BUTON_METNI', '$buton_metni_escaped') 
                       ON DUPLICATE KEY UPDATE deger = VALUES(deger)");
            
            // Sonra Telegram API'yi çağır
            $sonuc = $bot->kayitUrlButonuEkle($kayit_url, $buton_metni);
            
            if ($sonuc && $sonuc['ok']) {
                $mesaj = '<div class="alert alert-success">Kayıt URL butonu başarıyla güncellendi.</div>';
                // Değişkenleri güncelle ki sayfada doğru değerler görünsün
                $kayit_url = $kayit_url_escaped;
                $kayit_buton_metni = $buton_metni_escaped;
            } else {
                $hata_mesaji = isset($sonuc['description']) ? $sonuc['description'] : 'Bilinmeyen hata';
                $mesaj = '<div class="alert alert-danger">Kayıt URL butonu güncellenirken bir hata oluştu: ' . $hata_mesaji . '</div>';
                $mesaj .= '<div class="alert alert-info">Veritabanı güncellendi ancak Telegram API\'de güncelleme yapılamadı. Lütfen daha sonra tekrar deneyin.</div>';
            }
        }
    }
    
    // Webhook ayarlarını güncelle
    else if ($islem === 'webhook_guncelle') {
        $webhook_url = $_POST['webhook_url'] ?? '';
        $webhook_sertifika = isset($_FILES['webhook_sertifika']) && $_FILES['webhook_sertifika']['error'] === UPLOAD_ERR_OK ? $_FILES['webhook_sertifika']['tmp_name'] : null;
        
        if (empty($webhook_url)) {
            // Webhook'u kaldır
            $sonuc = $bot->webhookKaldir();
            
            if ($sonuc && $sonuc['ok']) {
                $mesaj = '<div class="alert alert-success">Webhook başarıyla kaldırıldı. Bot artık polling modunda çalışacak.</div>';
                $webhook_aktif = false;
                $webhook_url = '';
                
                // Webhook URL'sini veritabanından sil
                $vt->query("DELETE FROM ayarlar WHERE anahtar = 'SON_WEBHOOK_URL'");
            } else {
                $mesaj = '<div class="alert alert-danger">Webhook kaldırılırken bir hata oluştu.</div>';
            }
        } else {
            // Webhook'u ayarla
            $max_connections = $_POST['max_connections'] ?? 40;
            $allowed_updates = isset($_POST['allowed_updates']) ? $_POST['allowed_updates'] : ['message', 'callback_query'];
            
            $sonuc = $bot->webhookAyarla($webhook_url, $webhook_sertifika, $max_connections, $allowed_updates);
            
            if ($sonuc && $sonuc['ok']) {
                $mesaj = '<div class="alert alert-success">Webhook başarıyla ayarlandı.</div>';
                $webhook_aktif = true;
                $webhook_bilgisi = $bot->webhookBilgisiniGetir();
                
                // Webhook URL'sini veritabanına kaydet
                $vt->query("INSERT INTO ayarlar (anahtar, deger) VALUES ('SON_WEBHOOK_URL', '" . $vt->real_escape_string($webhook_url) . "') ON DUPLICATE KEY UPDATE deger = VALUES(deger)");
            } else {
                $hata_mesaji = isset($sonuc['description']) ? $sonuc['description'] : 'Bilinmeyen hata';
                $mesaj = '<div class="alert alert-danger">Webhook ayarlanırken bir hata oluştu: ' . $hata_mesaji . '</div>';
            }
        }
    }
    
    // Bot durumunu güncelle
    else if ($islem === 'durum_guncelle') {
        $bot_durum = $_POST['bot_durum'] ?? '';
        
        if ($bot_durum === 'aktif') {
            // Botu aktifleştir - webhook'u etkinleştir
            $son_webhook_url = ayarAl('SON_WEBHOOK_URL', '');
            
            if (!empty($son_webhook_url)) {
                // Eğer daha önce kaydedilmiş bir webhook URL'si varsa, onu kullan
                $sonuc = $bot->webhookAyarla($son_webhook_url);
                
                if ($sonuc && $sonuc['ok']) {
                    $mesaj = '<div class="alert alert-success">Bot başarıyla aktifleştirildi. Webhook yeniden ayarlandı.</div>';
                    $webhook_aktif = true;
                    $webhook_url = $son_webhook_url;
                    $webhook_bilgisi = $bot->webhookBilgisiniGetir();
                } else {
                    $hata_mesaji = isset($sonuc['description']) ? $sonuc['description'] : 'Bilinmeyen hata';
                    $mesaj = '<div class="alert alert-danger">Bot aktifleştirilirken bir hata oluştu: ' . $hata_mesaji . '</div>';
                }
            } else {
                // Webhook URL'si yoksa polling modunda aktifleştir
                $mesaj = '<div class="alert alert-success">Bot polling modunda aktifleştirildi. Webhook ayarlamak için lütfen webhook ayarları bölümünü kullanın.</div>';
            }
        } else {
            // Botu devre dışı bırak - webhook'u kaldır
            // Önce mevcut webhook URL'sini kaydet
            if ($webhook_aktif && !empty($webhook_url)) {
                $vt->query("INSERT INTO ayarlar (anahtar, deger) VALUES ('SON_WEBHOOK_URL', '" . $vt->real_escape_string($webhook_url) . "') ON DUPLICATE KEY UPDATE deger = VALUES(deger)");
            }
            
            // Sonra webhook'u kaldır
            $sonuc = $bot->webhookKaldir();
            
            if ($sonuc && $sonuc['ok']) {
                $mesaj = '<div class="alert alert-success">Bot devre dışı bırakıldı. Webhook kaldırıldı.</div>';
                $webhook_aktif = false;
                $webhook_url = '';
            } else {
                $mesaj = '<div class="alert alert-danger">Bot devre dışı bırakılırken bir hata oluştu.</div>';
            }
        }
    }
}

include 'includes/header.php';
?>

<div class="container-fluid px-4">
    <h1 class="mt-4"><?php echo $baslik; ?></h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
        <li class="breadcrumb-item active"><?php echo $baslik; ?></li>
    </ol>
    
    <?php echo $mesaj; ?>
    
    <div class="row">
        <!-- Sol Sütun - Temel Bot Ayarları -->
        <div class="col-xl-6">
            <!-- Bot Bilgileri Kartı -->
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <i class="fas fa-robot me-1"></i>
                    Bot Bilgileri
                </div>
                <div class="card-body">
                    <?php if ($bot_bilgileri && $bot_bilgileri['ok']): ?>
                        <div class="mb-3">
                            <h5>Bot ID</h5>
                            <p><?php echo $bot_bilgileri['result']['id']; ?></p>
                        </div>
                        
                        <div class="mb-3">
                            <h5>Bot Kullanıcı Adı</h5>
                            <p>@<?php echo $bot_bilgileri['result']['username']; ?></p>
                        </div>
                        
                        <form method="post" action="">
                            <input type="hidden" name="islem" value="isim_guncelle">
                            <div class="mb-3">
                                <label for="bot_ismi" class="form-label">Bot İsmi</label>
                                <input type="text" class="form-control" id="bot_ismi" name="bot_ismi" value="<?php echo $bot_bilgileri['result']['first_name']; ?>" required>
                                <div class="form-text">
                                    Botun ismini girin. Bu, kullanıcıların botunuzu gördüğünde görecekleri isimdir.
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">İsmi Güncelle</button>
                        </form>
                    <?php else: ?>
                        <div class="alert alert-warning">Bot bilgileri alınamadı.</div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Bot Kısa Açıklaması Kartı -->
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <i class="fas fa-comment me-1"></i>
                    Bot Kısa Açıklaması
                </div>
                <div class="card-body">
                    <form method="post" action="">
                        <input type="hidden" name="islem" value="kisa_aciklama_guncelle">
                        <div class="mb-3">
                            <label for="bot_kisa_aciklama" class="form-label">Bot Kısa Açıklaması</label>
                            <textarea class="form-control" id="bot_kisa_aciklama" name="bot_kisa_aciklama" rows="2" maxlength="120"><?php echo $bot_kisa_aciklamasi['result']['short_description'] ?? ''; ?></textarea>
                            <div class="form-text">
                                Botun kısa açıklamasını girin. Bu, kullanıcılar botunuzu aradığında görecekleri kısa açıklamadır. Maksimum 120 karakter olabilir.
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Kısa Açıklamayı Güncelle</button>
                    </form>
                </div>
            </div>
            
            <!-- Kayıt URL Butonu Kartı -->
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <i class="fas fa-link me-1"></i>
                    Kayıt URL Butonu
                </div>
                <div class="card-body">
                    <form method="post" action="">
                        <input type="hidden" name="islem" value="kayit_url_guncelle">
                        <div class="mb-3">
                            <label for="kayit_url" class="form-label">Kayıt URL'si</label>
                            <input type="text" class="form-control" id="kayit_url" name="kayit_url" placeholder="Kayıt URL'si" value="<?php echo $kayit_url; ?>" required>
                            <div class="form-text">
                                Kayıt URL'sini girin. Bu URL, kullanıcılar botunuzun menüsündeki butona tıkladığında açılacaktır.
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="buton_metni" class="form-label">Buton Metni</label>
                            <input type="text" class="form-control" id="buton_metni" name="buton_metni" placeholder="Buton Metni" value="<?php echo $kayit_buton_metni; ?>" required>
                            <div class="form-text">
                                Buton metnini girin. Bu metin, kullanıcılar botunuzun menüsünde görecekleri buton metnidir.
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Kayıt URL Butonunu Güncelle</button>
                    </form>
                </div>
            </div>
            
            <!-- Webhook Ayarları Kartı -->
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <i class="fas fa-cogs me-1"></i>
                    Webhook Ayarları
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <h5>Mevcut Webhook Durumu</h5>
                        <?php if ($webhook_aktif): ?>
                            <div class="alert alert-success">
                                <strong>Webhook Aktif</strong><br>
                                URL: <?php echo htmlspecialchars($webhook_url); ?>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-warning">
                                <strong>Webhook Aktif Değil</strong><br>
                                Bot şu anda polling modunda veya devre dışı.
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <form method="post" action="" enctype="multipart/form-data">
                        <input type="hidden" name="islem" value="webhook_guncelle">
                        <div class="mb-3">
                            <label for="webhook_url" class="form-label">Webhook URL</label>
                            <input type="url" class="form-control" id="webhook_url" name="webhook_url" 
                                   value="<?php echo htmlspecialchars($webhook_url); ?>" 
                                   placeholder="https://example.com/bot/webhook">
                            <div class="form-text">
                                Webhook URL'sini girin. Boş bırakırsanız webhook kaldırılacaktır.
                                <br>URL, HTTPS ile başlamalı ve genel olarak erişilebilir olmalıdır.
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="webhook_sertifika" class="form-label">SSL Sertifikası (İsteğe Bağlı)</label>
                            <input type="file" class="form-control" id="webhook_sertifika" name="webhook_sertifika">
                            <div class="form-text">
                                Özel bir SSL sertifikası kullanıyorsanız yükleyin. Genel bir sertifika kullanıyorsanız boş bırakabilirsiniz.
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="max_connections" class="form-label">Maksimum Bağlantı</label>
                            <input type="number" class="form-control" id="max_connections" name="max_connections" 
                                   value="40" min="1" max="100">
                            <div class="form-text">
                                Telegram'ın webhook sunucunuza açabileceği maksimum bağlantısı sayısı.
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">İzin Verilen Güncellemeler</label>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="update_message" name="allowed_updates[]" value="message" checked>
                                <label class="form-check-label" for="update_message">Mesajlar</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="update_callback" name="allowed_updates[]" value="callback_query" checked>
                                <label class="form-check-label" for="update_callback">Callback Sorguları</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="update_inline" name="allowed_updates[]" value="inline_query">
                                <label class="form-check-label" for="update_inline">Inline Sorguları</label>
                            </div>
                            <div class="form-text">
                                Webhook'un hangi güncelleme türlerini alacağını seçin.
                            </div>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Webhook Ayarlarını Güncelle</button>
                    </form>
                </div>
            </div>
        </div>
        
        <!-- Sağ Sütun - Gelişmiş Bot Ayarları -->
        <div class="col-xl-6">
            <!-- Bot Açıklaması Kartı -->
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <i class="fas fa-info-circle me-1"></i>
                    Bot Açıklaması
                </div>
                <div class="card-body">
                    <form method="post" action="">
                        <input type="hidden" name="islem" value="aciklama_guncelle">
                        <div class="mb-3">
                            <label for="bot_aciklama" class="form-label">Bot Açıklaması</label>
                            <textarea class="form-control" id="bot_aciklama" name="bot_aciklama" rows="3"><?php echo $bot_aciklamasi['result']['description'] ?? ''; ?></textarea>
                            <div class="form-text">
                                Botun açıklamasını girin. Bu, kullanıcılar botunuzu incelediğinde görecekleri detaylı açıklamadır.
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Açıklamayı Güncelle</button>
                    </form>
                </div>
            </div>
            
            <!-- Bot Profil Fotoğrafı Kartı -->
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <i class="fas fa-image me-1"></i>
                    Bot Profil Fotoğrafı
                </div>
                <div class="card-body">
                    <form method="post" action="" enctype="multipart/form-data">
                        <input type="hidden" name="islem" value="foto_guncelle">
                        <div class="mb-3">
                            <label for="bot_foto" class="form-label">Profil Fotoğrafı</label>
                            <input type="file" class="form-control" id="bot_foto" name="bot_foto" accept="image/png,image/jpeg" required>
                            <div class="form-text">
                                Botun profil fotoğrafını yükleyin. Fotoğraf kare şeklinde olmalıdır ve PNG veya JPEG formatında olmalıdır.
                                <br>Önerilen boyut: 640x640 piksel.
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Fotoğrafı Güncelle</button>
                    </form>
                </div>
            </div>
            
            <!-- Bot Komutları Kartı -->
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <i class="fas fa-terminal me-1"></i>
                    Bot Komutları
                </div>
                <div class="card-body">
                    <form method="post" action="">
                        <input type="hidden" name="islem" value="komutlar_guncelle">
                        <input type="hidden" id="komutSayisi" name="komut_sayisi" value="<?php echo count($bot_komutlari['result'] ?? []); ?>">
                        
                        <div id="komutlarContainer">
                            <?php if ($bot_komutlari && $bot_komutlari['ok'] && !empty($bot_komutlari['result'])): ?>
                                <?php foreach ($bot_komutlari['result'] as $index => $komut): ?>
                                    <div class="row mb-2 komut-satiri">
                                        <div class="col-md-4">
                                            <input type="text" class="form-control" name="komut_<?php echo $index; ?>" value="<?php echo $komut['command']; ?>" placeholder="Komut" required>
                                        </div>
                                        <div class="col-md-7">
                                            <input type="text" class="form-control" name="aciklama_<?php echo $index; ?>" value="<?php echo $komut['description']; ?>" placeholder="Açıklama" required>
                                        </div>
                                        <div class="col-md-1">
                                            <button type="button" class="btn btn-danger btn-sm komut-sil"><i class="fas fa-trash"></i></button>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                        
                        <div class="mb-3">
                            <button type="button" id="komutEkle" class="btn btn-success btn-sm">Komut Ekle</button>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Komutları Güncelle</button>
                    </form>
                </div>
            </div>
            
            <!-- Bot Durumu Kartı -->
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <i class="fas fa-power-off me-1"></i>
                    Bot Durumu
                </div>
                <div class="card-body">
                    <form method="post" action="">
                        <input type="hidden" name="islem" value="durum_guncelle">
                        <div class="mb-3">
                            <label class="form-label">Bot Çalışma Modu</label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="bot_durum" id="bot_aktif" value="aktif" <?php echo $webhook_aktif ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="bot_aktif">
                                    Aktif
                                </label>
                                <div class="form-text">
                                    Bot aktif olarak çalışacak ve mesajlara yanıt verecek.
                                </div>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="bot_durum" id="bot_pasif" value="pasif" <?php echo !$webhook_aktif ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="bot_pasif">
                                    Devre Dışı
                                </label>
                                <div class="form-text">
                                    Bot devre dışı bırakılacak ve mesajlara yanıt vermeyecek.
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Bot Durumunu Güncelle</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Komut ekleme
    document.getElementById('komutEkle').addEventListener('click', function() {
        const komutlarContainer = document.getElementById('komutlarContainer');
        const komutSayisi = document.getElementById('komutSayisi');
        const yeniIndex = parseInt(komutSayisi.value);
        
        const yeniSatir = document.createElement('div');
        yeniSatir.className = 'row mb-2 komut-satiri';
        yeniSatir.innerHTML = `
            <div class="col-md-4">
                <input type="text" class="form-control" name="komut_${yeniIndex}" placeholder="Komut" required>
            </div>
            <div class="col-md-7">
                <input type="text" class="form-control" name="aciklama_${yeniIndex}" placeholder="Açıklama" required>
            </div>
            <div class="col-md-1">
                <button type="button" class="btn btn-danger btn-sm komut-sil"><i class="fas fa-trash"></i></button>
            </div>
        `;
        
        komutlarContainer.appendChild(yeniSatir);
        komutSayisi.value = yeniIndex + 1;
        
        // Yeni eklenen silme butonuna olay dinleyici ekle
        yeniSatir.querySelector('.komut-sil').addEventListener('click', silKomut);
    });
    
    // Komut silme
    function silKomut() {
        const satir = this.closest('.komut-satiri');
        satir.remove();
        
        // Komut sayısını güncelle
        const satirlar = document.querySelectorAll('.komut-satiri');
        document.getElementById('komutSayisi').value = satirlar.length;
        
        // İndeksleri yeniden düzenle
        satirlar.forEach((satir, index) => {
            const komutInput = satir.querySelector('input[name^="komut_"]');
            const aciklamaInput = satir.querySelector('input[name^="aciklama_"]');
            
            komutInput.name = `komut_${index}`;
            aciklamaInput.name = `aciklama_${index}`;
        });
    }
    
    // Mevcut silme butonlarına olay dinleyici ekle
    document.querySelectorAll('.komut-sil').forEach(button => {
        button.addEventListener('click', silKomut);
    });
    
    // Kısa açıklama karakter sayısı kontrolü
    const kisaAciklamaTextarea = document.getElementById('bot_kisa_aciklama');
    if (kisaAciklamaTextarea) {
        kisaAciklamaTextarea.addEventListener('input', function() {
            if (this.value.length > 120) {
                this.value = this.value.substring(0, 120);
            }
        });
    }
});
</script>

<?php include 'includes/footer.php'; ?>
