<?php
require_once 'includes/auth.php';
require_once '../bot/config.php';
require_once '../bot/bildirimler.php';

$baslik = "Bildirim Gönder";
$mesaj = "";
$sonuc = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bildirim_tipi = $_POST['bildirim_tipi'] ?? '';
    $bildirim_mesaji = $_POST['bildirim_mesaji'] ?? '';
    $limit = $_POST['limit'] ?? 10;
    
    if (empty($bildirim_mesaji)) {
        $mesaj = '<div class="alert alert-danger">Lütfen bir bildirim mesajı girin.</div>';
    } else {
        switch ($bildirim_tipi) {
            case 'tum_kullanicilar':
                $sonuc = tumKullanicilara($bildirim_mesaji, 'markdown');
                break;
            case 'telefon_dogrulanmis':
                $sonuc = filtreliKullanicilara($bildirim_mesaji, ['telefon IS NOT' => 'NULL'], 'markdown');
                break;
            case 'en_cok_davet':
                $sonuc = enCokDavetEdenlere($bildirim_mesaji, $limit, 'markdown');
                break;
            case 'min_davet_asan':
                $min_davet = minDavetSayisiAl();
                $sonuc = minDavetAsanKullanicilara($bildirim_mesaji, $min_davet, 'markdown');
                break;
            default:
                $mesaj = '<div class="alert alert-danger">Geçersiz bildirim tipi.</div>';
                break;
        }
        
        if ($sonuc) {
            $mesaj = '<div class="alert alert-success">Bildirim gönderildi. Başarılı: ' . $sonuc['basarili'] . ', Başarısız: ' . $sonuc['basarisiz'] . '</div>';
        }
    }
}

include 'includes/header.php';
?>

<div class="container-fluid px-4">
    <h1 class="mt-4"><?php echo $baslik; ?></h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
        <li class="breadcrumb-item active"><?php echo $baslik; ?></li>
    </ol>
    
    <?php echo $mesaj; ?>
    
    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-bell me-1"></i>
            Bildirim Gönder
        </div>
        <div class="card-body">
            <form method="post" action="">
                <div class="mb-3">
                    <label for="bildirim_tipi" class="form-label">Bildirim Tipi</label>
                    <select class="form-select" id="bildirim_tipi" name="bildirim_tipi" required>
                        <option value="tum_kullanicilar">Tüm Kullanıcılara</option>
                        <option value="telefon_dogrulanmis">Telefon Numarası Doğrulanmış Kullanıcılara</option>
                        <option value="en_cok_davet">En Çok Davet Eden Kullanıcılara</option>
                        <option value="min_davet_asan"><?php echo minDavetSayisiAl(); ?>+ Davet Eden Kullanıcılara</option>
                    </select>
                </div>
                
                <div class="mb-3" id="limit_container" style="display: none;">
                    <label for="limit" class="form-label">Kullanıcı Limiti</label>
                    <input type="number" class="form-control" id="limit" name="limit" value="10" min="1" max="100">
                    <div class="form-text">En çok davet eden kaç kullanıcıya bildirim gönderileceğini belirtin.</div>
                </div>
                
                <div class="mb-3">
                    <label for="bildirim_mesaji" class="form-label">Bildirim Mesajı</label>
                    <textarea class="form-control" id="bildirim_mesaji" name="bildirim_mesaji" rows="5" required></textarea>
                    <div class="form-text">
                        <strong>Markdown formatını kullanabilirsiniz:</strong><br>
                        *italik* için yıldız, **kalın** için çift yıldız, [link](https://example.com) için köşeli ve normal parantez kullanın.
                    </div>
                </div>
                
                <div class="mb-3">
                    <h5>Önizleme</h5>
                    <div class="card">
                        <div class="card-body" id="bildirimOnizleme">
                            <!-- JavaScript ile önizleme burada gösterilecek -->
                        </div>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">Bildirim Gönder</button>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const bildirimTipi = document.getElementById('bildirim_tipi');
    const limitContainer = document.getElementById('limit_container');
    const bildirimMesaji = document.getElementById('bildirim_mesaji');
    const bildirimOnizleme = document.getElementById('bildirimOnizleme');
    
    bildirimTipi.addEventListener('change', function() {
        if (this.value === 'en_cok_davet') {
            limitContainer.style.display = 'block';
        } else {
            limitContainer.style.display = 'none';
        }
    });
    
    // Markdown'ı HTML'e dönüştür ve önizleme olarak göster
    function updatePreview() {
        const markdown = bildirimMesaji.value;
        // Satır sonlarını <br> etiketine dönüştür
        const htmlWithLineBreaks = markdown.replace(/\n/g, '<br>');
        // Markdown'ı HTML'e dönüştür
        bildirimOnizleme.innerHTML = marked.parse(htmlWithLineBreaks);
    }
    
    // Sayfa yüklendiğinde önizlemeyi güncelle
    updatePreview();
    
    // Textarea değiştiğinde önizlemeyi güncelle
    bildirimMesaji.addEventListener('input', updatePreview);
});
</script>

<?php include 'includes/footer.php'; ?>
