<?php
/**
 * Betplay Davet Turnuvası - Yönetim Paneli
 * Ayarlar Sayfası
 */
require_once '../bot/config.php';
require_once 'includes/header.php';

// Ayarları veritabanından al
$ayarlar_sorgu = "SELECT * FROM ayarlar ORDER BY id ASC";
$ayarlar_sonuc = $vt->query($ayarlar_sorgu);
$ayarlar = [];

while ($ayar = $ayarlar_sonuc->fetch_assoc()) {
    $ayarlar[$ayar['anahtar']] = $ayar;
}

// Ayarları güncelle
$mesaj = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['ayarlar_guncelle'])) {
        // Ayarları güncelle
        $turnuva_baslangic = $_POST['turnuva_baslangic'];
        $turnuva_bitis = $_POST['turnuva_bitis'];
        $min_davet_sayisi = $_POST['min_davet_sayisi'];
        $freebet_miktari = $_POST['freebet_miktari'];
        $ekstra_odul_miktari = $_POST['ekstra_odul_miktari'];
        $telefon_zorunlu = isset($_POST['telefon_zorunlu']) ? '1' : '0';
        
        // Üst ödülleri JSON formatına dönüştür
        $ust_oduller = [];
        for ($i = 1; $i <= 5; $i++) {
            $ust_oduller[] = [
                'sira' => $i,
                'odul' => intval($_POST['ust_odul_' . $i])
            ];
        }
        $ust_oduller_json = json_encode($ust_oduller);
        
        // Ayarları veritabanında güncelle
        $vt->query("UPDATE ayarlar SET deger = '$turnuva_baslangic' WHERE anahtar = 'TURNUVA_BASLANGIC'");
        $vt->query("UPDATE ayarlar SET deger = '$turnuva_bitis' WHERE anahtar = 'TURNUVA_BITIS'");
        $vt->query("UPDATE ayarlar SET deger = '$min_davet_sayisi' WHERE anahtar = 'MIN_DAVET_SAYISI'");
        $vt->query("UPDATE ayarlar SET deger = '$freebet_miktari' WHERE anahtar = 'FREEBET_MIKTARI'");
        $vt->query("UPDATE ayarlar SET deger = '$ekstra_odul_miktari' WHERE anahtar = 'EKSTRA_ODUL_MIKTARI'");
        $vt->query("UPDATE ayarlar SET deger = '$ust_oduller_json' WHERE anahtar = 'UST_ODULLER'");
        $vt->query("UPDATE ayarlar SET deger = '$telefon_zorunlu' WHERE anahtar = 'TELEFON_ZORUNLU'");
        
        // Ayarları yeniden yükle
        $ayarlar_sorgu = "SELECT * FROM ayarlar ORDER BY id ASC";
        $ayarlar_sonuc = $vt->query($ayarlar_sorgu);
        $ayarlar = [];
        
        while ($ayar = $ayarlar_sonuc->fetch_assoc()) {
            $ayarlar[$ayar['anahtar']] = $ayar;
        }
        
        $mesaj = '<div class="alert alert-success">Ayarlar başarıyla güncellendi.</div>';
    }
    
    // Etkinliği başlat/durdur
    if (isset($_POST['etkinlik_durum_degistir'])) {
        $yeni_durum = isset($_POST['yeni_durum']) ? $_POST['yeni_durum'] : '';
        $simdi = date('Y-m-d H:i:s');
        
        if ($yeni_durum === 'baslat') {
            // Etkinliği başlat - başlangıç tarihini şimdi yap, bitiş tarihini formdan alınan değer olarak kullan
            $vt->query("UPDATE ayarlar SET deger = '$simdi' WHERE anahtar = 'TURNUVA_BASLANGIC'");
            
            // Bitiş tarihini formdan al veya varsayılan olarak ayarla
            $bitis = isset($ayarlar['TURNUVA_BITIS']['deger']) ? $ayarlar['TURNUVA_BITIS']['deger'] : date('Y-m-d H:i:s', strtotime('+10 days'));
            $vt->query("UPDATE ayarlar SET deger = '$bitis' WHERE anahtar = 'TURNUVA_BITIS'");
            
            // Tüm kullanıcılara bildirim gönder
            require_once '../bot/config.php';
            require_once '../bot/BotAPI.php';
            require_once '../bot/bildirimler.php';
            
            try {
                // Doğrudan test mesajı gönder (debug için)
                $test_mesaji = "🔔 *ETKİNLİK BAŞLADI*\n\nBetplay Davet Turnuvası başladı! Hemen arkadaşlarını davet et ve ödüller kazan!";
                $sonuc = tumKullanicilara($test_mesaji);
                
                // Sonuçları göster
                $mesaj = '<div class="alert alert-success">Etkinlik başarıyla başlatıldı! Bitiş tarihi: ' . $bitis . '<br>Bildirim gönderilen kullanıcı sayısı: ' . $sonuc['basarili'] . '</div>';
                
                // Ayarları yeniden yükle
                $ayarlar_sorgu = "SELECT * FROM ayarlar ORDER BY id ASC";
                $ayarlar_sonuc = $vt->query($ayarlar_sorgu);
                $ayarlar = [];
                
                while ($ayar = $ayarlar_sonuc->fetch_assoc()) {
                    $ayarlar[$ayar['anahtar']] = $ayar;
                }
            } catch (Exception $e) {
                $mesaj = '<div class="alert alert-success">Etkinlik başarıyla başlatıldı! Bitiş tarihi: ' . $bitis . '<br><span class="text-warning">Bildirim gönderilirken bir hata oluştu: ' . $e->getMessage() . '</span></div>';
            }
        } else if ($yeni_durum === 'durdur') {
            // Etkinliği durdur - bitiş tarihini şimdi yap ve başlangıç tarihini de şimdi yaparak tamamen kapat
            $vt->query("UPDATE ayarlar SET deger = '$simdi' WHERE anahtar = 'TURNUVA_BITIS'");
            
            // Başlangıç tarihini de bitiş tarihiyle aynı yap (etkinliği tamamen kapat)
            $vt->query("UPDATE ayarlar SET deger = '$simdi' WHERE anahtar = 'TURNUVA_BASLANGIC'");
            
            // Tüm kullanıcılara bildirim gönder
            require_once '../bot/config.php';
            require_once '../bot/BotAPI.php';
            require_once '../bot/bildirimler.php';
            
            try {
                // Doğrudan test mesajı gönder (debug için)
                $test_mesaji = "⚠️ *ETKİNLİK SONA ERDİ*\n\nBetplay Davet Turnuvası sona erdi. Kazananlar yakında açıklanacak!";
                $sonuc = tumKullanicilara($test_mesaji);
                
                // Sonuçları göster
                $mesaj = '<div class="alert alert-warning">Etkinlik başarıyla durduruldu ve kapatıldı!<br>Bildirim gönderilen kullanıcı sayısı: ' . $sonuc['basarili'] . '</div>';
                
                // Ayarları yeniden yükle
                $ayarlar_sorgu = "SELECT * FROM ayarlar ORDER BY id ASC";
                $ayarlar_sonuc = $vt->query($ayarlar_sorgu);
                $ayarlar = [];
                
                while ($ayar = $ayarlar_sonuc->fetch_assoc()) {
                    $ayarlar[$ayar['anahtar']] = $ayar;
                }
            } catch (Exception $e) {
                $mesaj = '<div class="alert alert-warning">Etkinlik başarıyla durduruldu ve kapatıldı!<br><span class="text-warning">Bildirim gönderilirken bir hata oluştu: ' . $e->getMessage() . '</span></div>';
            }
        }
    }
}
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Ayarlar</h1>
        <div>
            <a href="index.php" class="btn btn-outline-secondary me-2"><i class="fas fa-arrow-left"></i> Geri</a>
        </div>
    </div>
    
    <?php echo $mesaj; ?>
    
    <div class="row">
        <!-- Sol Taraf: Turnuva Ayarları ve Etkinlik Kontrolleri -->
        <div class="col-md-6">
            <!-- Turnuva Ayarları Kartı -->
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-cog"></i> Turnuva Ayarları</h5>
                </div>
                <div class="card-body">
                    <form method="post" id="ayarlarForm">
                        <div class="form-group mb-3">
                            <label for="turnuva_baslangic" class="form-label">Turnuva Başlangıç Tarihi</label>
                            <input type="datetime-local" class="form-control" id="turnuva_baslangic" name="turnuva_baslangic" value="<?php echo isset($ayarlar['TURNUVA_BASLANGIC']['deger']) ? date('Y-m-d\TH:i', strtotime($ayarlar['TURNUVA_BASLANGIC']['deger'])) : date('Y-m-d\TH:i'); ?>">
                            <small class="form-text text-muted">Turnuvanın başlangıç tarihi ve saati</small>
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="turnuva_bitis" class="form-label">Turnuva Bitiş Tarihi</label>
                            <input type="datetime-local" class="form-control" id="turnuva_bitis" name="turnuva_bitis" value="<?php echo isset($ayarlar['TURNUVA_BITIS']['deger']) ? date('Y-m-d\TH:i', strtotime($ayarlar['TURNUVA_BITIS']['deger'])) : date('Y-m-d\TH:i', strtotime('+10 days')); ?>">
                            <small class="form-text text-muted">Turnuvanın bitiş tarihi ve saati</small>
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="min_davet_sayisi" class="form-label">Minimum Davet Sayısı</label>
                            <input type="number" class="form-control" id="min_davet_sayisi" name="min_davet_sayisi" value="<?php echo isset($ayarlar['MIN_DAVET_SAYISI']['deger']) ? $ayarlar['MIN_DAVET_SAYISI']['deger'] : 5; ?>">
                            <small class="form-text text-muted">Freebet kazanmak için gerekli minimum davet sayısı</small>
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="freebet_miktari" class="form-label">Freebet Miktarı (TL)</label>
                            <input type="number" class="form-control" id="freebet_miktari" name="freebet_miktari" value="<?php echo isset($ayarlar['FREEBET_MIKTARI']['deger']) ? $ayarlar['FREEBET_MIKTARI']['deger'] : 500; ?>">
                            <small class="form-text text-muted">Minimum davet sayısını aşanlara verilecek freebet miktarı</small>
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="ekstra_odul_miktari" class="form-label">Ekstra Davet Başına Ödül (TL)</label>
                            <input type="number" class="form-control" id="ekstra_odul_miktari" name="ekstra_odul_miktari" value="<?php echo isset($ayarlar['EKSTRA_ODUL_MIKTARI']['deger']) ? $ayarlar['EKSTRA_ODUL_MIKTARI']['deger'] : 100; ?>">
                            <small class="form-text text-muted">Minimum davet sayısının üzerindeki her davet için verilecek ek ödül miktarı</small>
                        </div>
                        
                        <div class="form-group mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="telefon_zorunlu" name="telefon_zorunlu" <?php echo (isset($ayarlar['TELEFON_ZORUNLU']['deger']) && $ayarlar['TELEFON_ZORUNLU']['deger'] == '1') ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="telefon_zorunlu">Telefon Numarası Zorunlu</label>
                            </div>
                            <small class="form-text text-muted">Kullanıcıların davet linki alabilmek için telefon numarası paylaşması zorunlu olsun mu?</small>
                        </div>
                        
                        <!-- Üst ödüller için gizli alanlar -->
                        <?php 
                        // Üst ödülleri güvenli bir şekilde işle
                        $ust_oduller = [];
                        if (isset($ayarlar['UST_ODULLER']['deger']) && !empty($ayarlar['UST_ODULLER']['deger'])) {
                            $ust_oduller_json = $ayarlar['UST_ODULLER']['deger'];
                            $decoded = json_decode($ust_oduller_json, true);
                            if (is_array($decoded)) {
                                $ust_oduller = $decoded;
                            }
                        }
                        
                        for ($i = 1; $i <= 5; $i++): 
                            // Değeri güvenli bir şekilde al
                            $odul_value = 0;
                            foreach ($ust_oduller as $odul) {
                                if (isset($odul['sira']) && $odul['sira'] == $i && isset($odul['odul'])) {
                                    $odul_value = $odul['odul'];
                                    break;
                                }
                            }
                        ?>
                            <input type="hidden" name="ust_odul_<?php echo $i; ?>" id="hidden_ust_odul_<?php echo $i; ?>" value="<?php echo $odul_value; ?>">
                        <?php endfor; ?>
                        
                        <input type="hidden" name="ust_oduller" id="UST_ODULLER_JSON" value="<?php echo isset($ayarlar['UST_ODULLER']['deger']) ? htmlspecialchars($ayarlar['UST_ODULLER']['deger']) : '[]'; ?>">
                        
                        <div class="form-group">
                            <button type="submit" name="ayarlar_guncelle" class="btn btn-primary w-100">
                                <i class="fas fa-save"></i> Tüm Ayarları Kaydet
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Etkinlik Kontrolleri Kartı -->
            <div class="card mb-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="fas fa-play-circle"></i> Etkinlik Kontrolleri</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <form method="post">
                                <input type="hidden" name="yeni_durum" value="baslat">
                                <button type="submit" name="etkinlik_durum_degistir" class="btn btn-success w-100">
                                    <i class="fas fa-play"></i> Etkinliği Başlat
                                </button>
                            </form>
                        </div>
                        <div class="col-md-6 mb-3">
                            <form method="post">
                                <input type="hidden" name="yeni_durum" value="durdur">
                                <button type="submit" name="etkinlik_durum_degistir" class="btn btn-danger w-100">
                                    <i class="fas fa-stop"></i> Etkinliği Durdur
                                </button>
                            </form>
                        </div>
                    </div>
                    
                    <div class="alert alert-info mt-3">
                        <h6><i class="fas fa-info-circle"></i> Etkinlik Durumu:</h6>
                        <?php
                        // Etkinlik aktif mi kontrol et
                        $simdi = date('Y-m-d H:i:s');
                        $baslangic = isset($ayarlar['TURNUVA_BASLANGIC']['deger']) ? $ayarlar['TURNUVA_BASLANGIC']['deger'] : '';
                        $bitis = isset($ayarlar['TURNUVA_BITIS']['deger']) ? $ayarlar['TURNUVA_BITIS']['deger'] : '';
                        
                        if ($simdi >= $baslangic && $simdi <= $bitis) {
                            echo '<div class="text-success"><i class="fas fa-check-circle"></i> <strong>Etkinlik Aktif</strong></div>';
                            echo '<div>Başlangıç: ' . date('d.m.Y H:i', strtotime($baslangic)) . '</div>';
                            echo '<div>Bitiş: ' . date('d.m.Y H:i', strtotime($bitis)) . '</div>';
                            
                            // Kalan süreyi hesapla
                            $kalan_sure = strtotime($bitis) - time();
                            $kalan_gun = floor($kalan_sure / (60 * 60 * 24));
                            $kalan_saat = floor(($kalan_sure % (60 * 60 * 24)) / (60 * 60));
                            echo '<div class="mt-2">Kalan Süre: <strong>' . $kalan_gun . ' gün ' . $kalan_saat . ' saat</strong></div>';
                        } else {
                            echo '<div class="text-danger"><i class="fas fa-times-circle"></i> <strong>Etkinlik Aktif Değil</strong></div>';
                            if ($simdi < $baslangic) {
                                echo '<div>Başlangıç Tarihi: ' . date('d.m.Y H:i', strtotime($baslangic)) . '</div>';
                                
                                // Kalan süreyi hesapla
                                $kalan_sure = strtotime($baslangic) - time();
                                $kalan_gun = floor($kalan_sure / (60 * 60 * 24));
                                $kalan_saat = floor(($kalan_sure % (60 * 60 * 24)) / (60 * 60));
                                echo '<div class="mt-2">Başlamasına Kalan Süre: <strong>' . $kalan_gun . ' gün ' . $kalan_saat . ' saat</strong></div>';
                            } else {
                                echo '<div>Son Etkinlik Bitiş Tarihi: ' . date('d.m.Y H:i', strtotime($bitis)) . '</div>';
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Sağ Taraf: Üst Ödüller -->
        <div class="col-md-6">
            <!-- Üst Ödüller Kartı -->
            <div class="card mb-4">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0"><i class="fas fa-trophy"></i> Üst Sıralama Ödülleri</h5>
                </div>
                <div class="card-body">
                    <div id="odullerForm">
                        <?php 
                        // Üst ödülleri güvenli bir şekilde işle
                        $ust_oduller = [];
                        if (isset($ayarlar['UST_ODULLER']['deger']) && !empty($ayarlar['UST_ODULLER']['deger'])) {
                            $ust_oduller_json = $ayarlar['UST_ODULLER']['deger'];
                            $decoded = json_decode($ust_oduller_json, true);
                            if (is_array($decoded)) {
                                $ust_oduller = $decoded;
                            }
                        }
                        
                        // Toplam ödül miktarını hesapla
                        $toplam_odul = 0;
                        
                        for ($i = 1; $i <= 5; $i++): 
                            // Değeri güvenli bir şekilde al
                            $odul_value = 0;
                            foreach ($ust_oduller as $odul) {
                                if (isset($odul['sira']) && $odul['sira'] == $i && isset($odul['odul'])) {
                                    $odul_value = $odul['odul'];
                                    $toplam_odul += $odul_value;
                                    break;
                                }
                            }
                            
                            // Ödül sırası için emoji belirle
                            $emoji = '';
                            switch ($i) {
                                case 1: $emoji = '🥇'; break;
                                case 2: $emoji = '🥈'; break;
                                case 3: $emoji = '🥉'; break;
                                default: $emoji = '🏅'; break;
                            }
                        ?>
                            <div class="form-group mb-3">
                                <label for="ust_odul_<?php echo $i; ?>" class="form-label"><?php echo $emoji; ?> <?php echo $i; ?>. Sıra Ödülü (TL)</label>
                                <div class="input-group">
                                    <span class="input-group-text">₺</span>
                                    <input type="number" class="form-control odul-input" id="ust_odul_<?php echo $i; ?>" data-sira="<?php echo $i; ?>" value="<?php echo $odul_value; ?>">
                                </div>
                            </div>
                        <?php endfor; ?>
                        
                        <div class="alert alert-warning mt-3">
                            <strong>Toplam Ödül Miktarı:</strong> <span id="toplam_odul"><?php echo number_format($toplam_odul, 0, ',', '.'); ?></span> TL
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Turnuva İstatistikleri Kartı -->
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="fas fa-chart-bar"></i> Turnuva İstatistikleri</h5>
                </div>
                <div class="card-body">
                    <?php
                    // Toplam kullanıcı sayısı
                    $toplam_kullanici = $vt->query("SELECT COUNT(*) as toplam FROM kullanicilar WHERE aktif = 1")->fetch_assoc()['toplam'];
                    
                    // Toplam davet sayısı
                    $toplam_davet = $vt->query("SELECT COUNT(*) as toplam FROM davetler WHERE aktif = TRUE")->fetch_assoc()['toplam'];
                    
                    // Minimum davet sayısını aşan kullanıcı sayısı
                    $min_davet = isset($ayarlar['MIN_DAVET_SAYISI']['deger']) ? $ayarlar['MIN_DAVET_SAYISI']['deger'] : 5;
                    $min_davet_asan = $vt->query("
                        SELECT COUNT(*) as toplam 
                        FROM (
                            SELECT COUNT(*) as davet_sayisi 
                            FROM davetler d 
                            JOIN kullanicilar k ON d.davet_eden_id = k.id 
                            WHERE d.aktif = TRUE 
                            GROUP BY k.telegram_id 
                            HAVING davet_sayisi >= $min_davet
                        ) as t
                    ")->fetch_assoc()['toplam'];
                    ?>
                    
                    <div class="row text-center">
                        <div class="col-md-4 mb-3">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h3 class="text-primary"><?php echo $toplam_kullanici; ?></h3>
                                    <p class="mb-0">Toplam Kullanıcı</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h3 class="text-success"><?php echo $toplam_davet; ?></h3>
                                    <p class="mb-0">Toplam Davet</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h3 class="text-warning"><?php echo $min_davet_asan; ?></h3>
                                    <p class="mb-0">Ödül Kazanan</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="text-center mt-3">
                        <a href="istatistikler.php" class="btn btn-outline-info">
                            <i class="fas fa-chart-line"></i> Detaylı İstatistikler
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Ödül inputları değiştiğinde toplam ödül miktarını güncelle ve gizli alanlara aktar
    const odulInputlar = document.querySelectorAll('.odul-input');
    
    odulInputlar.forEach(function(input) {
        input.addEventListener('input', function() {
            // Toplam ödül miktarını güncelle
            let toplam = 0;
            odulInputlar.forEach(function(inp) {
                toplam += parseInt(inp.value) || 0;
            });
            
            // Toplam ödül miktarını göster
            document.getElementById('toplam_odul').textContent = new Intl.NumberFormat('tr-TR').format(toplam);
            
            // Gizli alana değeri aktar
            const sira = this.getAttribute('data-sira');
            document.getElementById('hidden_ust_odul_' + sira).value = this.value;
            
            // JSON güncelle
            updateOdullerJSON();
        });
    });
    
    // Form gönderilmeden önce üst ödülleri JSON'a dönüştür
    document.getElementById('ayarlarForm').addEventListener('submit', function() {
        updateOdullerJSON();
    });
    
    // İlk yüklemede gizli alanlara değerleri aktar
    odulInputlar.forEach(function(input) {
        const sira = input.getAttribute('data-sira');
        document.getElementById('hidden_ust_odul_' + sira).value = input.value;
    });
    
    // İlk yüklemede JSON güncelle
    updateOdullerJSON();
    
    // Üst ödülleri JSON formatına dönüştür
    function updateOdullerJSON() {
        var ustOduller = [];
        odulInputlar.forEach(function(input) {
            ustOduller.push({
                sira: parseInt(input.getAttribute('data-sira')),
                odul: parseInt(input.value) || 0
            });
        });
        document.getElementById('UST_ODULLER_JSON').value = JSON.stringify(ustOduller);
    }
});
</script>

<?php require_once 'includes/footer.php'; ?>
